/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDistributionConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetDistributionConfigResponse> {
    private final DistributionConfig distributionConfig;
    private final String eTag;

    private GetDistributionConfigResponse(BuilderImpl builder) {
        super(builder);
        this.distributionConfig = builder.distributionConfig;
        this.eTag = builder.eTag;
    }

    public DistributionConfig distributionConfig() {
        return this.distributionConfig;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionConfigResponse)) {
            return false;
        }
        GetDistributionConfigResponse other = (GetDistributionConfigResponse)((Object)obj);
        return Objects.equals(this.distributionConfig(), other.distributionConfig()) && Objects.equals(this.eTag(), other.eTag());
    }

    public String toString() {
        return ToString.builder((String)"GetDistributionConfigResponse").add("DistributionConfig", (Object)this.distributionConfig()).add("ETag", (Object)this.eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DistributionConfig": {
                return Optional.of(clazz.cast(this.distributionConfig()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private DistributionConfig distributionConfig;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionConfigResponse model) {
            super(model);
            this.distributionConfig(model.distributionConfig);
            this.eTag(model.eTag);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return this.distributionConfig != null ? this.distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetDistributionConfigResponse build() {
            return new GetDistributionConfigResponse(this);
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    CopyableBuilder<Builder, GetDistributionConfigResponse> {
        public Builder distributionConfig(DistributionConfig var1);

        default public Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return this.distributionConfig((DistributionConfig)((DistributionConfig.Builder)DistributionConfig.builder().apply(distributionConfig)).build());
        }

        public Builder eTag(String var1);
    }
}

