/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteCloudFrontOriginAccessIdentityRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, DeleteCloudFrontOriginAccessIdentityRequest> {
    private final String id;
    private final String ifMatch;

    private DeleteCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        DeleteCloudFrontOriginAccessIdentityRequest other = (DeleteCloudFrontOriginAccessIdentityRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCloudFrontOriginAccessIdentityRequest").add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.of(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCloudFrontOriginAccessIdentityRequest model) {
            super(model);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteCloudFrontOriginAccessIdentityRequest build() {
            return new DeleteCloudFrontOriginAccessIdentityRequest(this);
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    CopyableBuilder<Builder, DeleteCloudFrontOriginAccessIdentityRequest> {
        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

