/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeadersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomHeaders
implements ToCopyableBuilder<Builder, CustomHeaders> {
    private final Integer quantity;
    private final List<OriginCustomHeader> items;

    private CustomHeaders(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<OriginCustomHeader> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomHeaders)) {
            return false;
        }
        CustomHeaders other = (CustomHeaders)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"CustomHeaders").add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.of(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.of(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<OriginCustomHeader> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomHeaders model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<OriginCustomHeader.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(OriginCustomHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<OriginCustomHeader> items) {
            this.items = OriginCustomHeadersListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OriginCustomHeader ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<OriginCustomHeader.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (OriginCustomHeader)((OriginCustomHeader.Builder)OriginCustomHeader.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<OriginCustomHeader.BuilderImpl> items) {
            this.items = OriginCustomHeadersListCopier.copyFromBuilder(items);
        }

        public CustomHeaders build() {
            return new CustomHeaders(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomHeaders> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<OriginCustomHeader> var1);

        public Builder items(OriginCustomHeader ... var1);

        public Builder items(Consumer<OriginCustomHeader.Builder> ... var1);
    }
}

