/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.services.cloudfront.auth.Pem;
import software.amazon.awssdk.services.cloudfront.auth.Rsa;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.Base64Utils;
import software.amazon.awssdk.utils.IoUtils;

public class SignerUtils {
    private static final SecureRandom SRAND = new SecureRandom();

    public static String buildCannedPolicy(String resourceUrlOrPath, Date dateLessThan) {
        return "{\"Statement\":[{\"Resource\":\"" + resourceUrlOrPath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(dateLessThan.getTime()) + "}}}]}";
    }

    public static String buildCustomPolicy(String resourcePath, Date expiresOn, Date activeFrom, String ipAddress) {
        return "{\"Statement\": [{\"Resource\":\"" + resourcePath + "\",\"Condition\":{\"DateLessThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(expiresOn.getTime()) + "}" + (ipAddress == null ? "" : ",\"IpAddress\":{\"AWS:SourceIp\":\"" + ipAddress + "\"}") + (activeFrom == null ? "" : ",\"DateGreaterThan\":{\"AWS:EpochTime\":" + TimeUnit.MILLISECONDS.toSeconds(activeFrom.getTime()) + "}") + "}}]}";
    }

    public static String makeBytesUrlSafe(byte[] bytes) {
        byte[] encoded = Base64Utils.encode((byte[])bytes);
        block5: for (int i = 0; i < encoded.length; ++i) {
            switch (encoded[i]) {
                case 43: {
                    encoded[i] = 45;
                    continue block5;
                }
                case 61: {
                    encoded[i] = 95;
                    continue block5;
                }
                case 47: {
                    encoded[i] = 126;
                    continue block5;
                }
            }
        }
        return new String(encoded, StringUtils.UTF8);
    }

    public static String makeStringUrlSafe(String str) {
        return SignerUtils.makeBytesUrlSafe(str.getBytes(StringUtils.UTF8));
    }

    public static String generateResourcePath(Protocol protocol, String distributionDomain, String resourcePath) {
        return protocol == Protocol.http || protocol == Protocol.https ? (Object)((Object)protocol) + "://" + distributionDomain + "/" + resourcePath : resourcePath;
    }

    public static byte[] signWithSha1Rsa(byte[] dataToSign, PrivateKey privateKey) throws InvalidKeyException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(privateKey, SRAND);
            signature.update(dataToSign);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadPrivateKey(File privateKeyFile) throws InvalidKeySpecException, IOException {
        if (StringUtils.lowerCase((String)privateKeyFile.getAbsolutePath()).endsWith(".pem")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = Pem.readPrivateKey(is);
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        if (StringUtils.lowerCase((String)privateKeyFile.getAbsolutePath()).endsWith(".der")) {
            FileInputStream is = new FileInputStream(privateKeyFile);
            try {
                PrivateKey privateKey = Rsa.privateKeyFromPkcs8(IoUtils.toByteArray((InputStream)is));
                return privateKey;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new AmazonClientException("Unsupported file type for private key");
    }

    public static enum Protocol {
        http,
        https,
        rtmp;

    }
}

