/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionList;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionSummary;
import software.amazon.awssdk.services.cloudfront.transform.StreamingDistributionSummaryUnmarshaller;

public class StreamingDistributionListUnmarshaller
implements Unmarshaller<StreamingDistributionList, StaxUnmarshallerContext> {
    private static StreamingDistributionListUnmarshaller INSTANCE;

    public StreamingDistributionList unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StreamingDistributionList.Builder streamingDistributionList = StreamingDistributionList.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Marker", targetDepth)) {
                    streamingDistributionList.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NextMarker", targetDepth)) {
                    streamingDistributionList.nextMarker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxItems", targetDepth)) {
                    streamingDistributionList.maxItems(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsTruncated", targetDepth)) {
                    streamingDistributionList.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    streamingDistributionList.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    streamingDistributionList.items(new ArrayList<StreamingDistributionSummary>());
                    continue;
                }
                if (!context.testExpression("Items/StreamingDistributionSummary", targetDepth)) continue;
                streamingDistributionList.items(StreamingDistributionSummaryUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StreamingDistributionList)streamingDistributionList.build();
    }

    public static StreamingDistributionListUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StreamingDistributionListUnmarshaller();
        }
        return INSTANCE;
    }
}

