/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.Headers;

public class HeadersUnmarshaller
implements Unmarshaller<Headers, StaxUnmarshallerContext> {
    private static HeadersUnmarshaller INSTANCE;

    public Headers unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Headers.Builder headers = Headers.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    headers.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    headers.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Name", targetDepth)) continue;
                headers.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Headers)headers.build();
    }

    public static HeadersUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HeadersUnmarshaller();
        }
        return INSTANCE;
    }
}

