/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;

public class GetInvalidationRequestMarshaller
implements Marshaller<Request<GetInvalidationRequest>, GetInvalidationRequest> {
    public Request<GetInvalidationRequest> marshall(GetInvalidationRequest getInvalidationRequest) {
        if (getInvalidationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getInvalidationRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2017-03-25/distribution/{DistributionId}/invalidation/{Id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DistributionId", getInvalidationRequest.distributionId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", getInvalidationRequest.id());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

