/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.transform.AliasesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CacheBehaviorsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CustomErrorResponsesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DefaultCacheBehaviorUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.OriginsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.RestrictionsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ViewerCertificateUnmarshaller;

public class DistributionSummaryUnmarshaller
implements Unmarshaller<DistributionSummary, StaxUnmarshallerContext> {
    private static DistributionSummaryUnmarshaller INSTANCE;

    public DistributionSummary unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DistributionSummary.Builder distributionSummary = DistributionSummary.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    distributionSummary.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ARN", targetDepth)) {
                    distributionSummary.arn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    distributionSummary.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    distributionSummary.lastModifiedTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    distributionSummary.domainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Aliases", targetDepth)) {
                    distributionSummary.aliases(AliasesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Origins", targetDepth)) {
                    distributionSummary.origins(OriginsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCacheBehavior", targetDepth)) {
                    distributionSummary.defaultCacheBehavior(DefaultCacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheBehaviors", targetDepth)) {
                    distributionSummary.cacheBehaviors(CacheBehaviorsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomErrorResponses", targetDepth)) {
                    distributionSummary.customErrorResponses(CustomErrorResponsesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Comment", targetDepth)) {
                    distributionSummary.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PriceClass", targetDepth)) {
                    distributionSummary.priceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    distributionSummary.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ViewerCertificate", targetDepth)) {
                    distributionSummary.viewerCertificate(ViewerCertificateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Restrictions", targetDepth)) {
                    distributionSummary.restrictions(RestrictionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("WebACLId", targetDepth)) {
                    distributionSummary.webACLId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HttpVersion", targetDepth)) {
                    distributionSummary.httpVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsIPV6Enabled", targetDepth)) continue;
                distributionSummary.isIPV6Enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DistributionSummary)distributionSummary.build();
    }

    public static DistributionSummaryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DistributionSummaryUnmarshaller();
        }
        return INSTANCE;
    }
}

