/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;

public class CustomErrorResponseUnmarshaller
implements Unmarshaller<CustomErrorResponse, StaxUnmarshallerContext> {
    private static CustomErrorResponseUnmarshaller INSTANCE;

    public CustomErrorResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CustomErrorResponse.Builder customErrorResponse = CustomErrorResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ErrorCode", targetDepth)) {
                    customErrorResponse.errorCode(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResponsePagePath", targetDepth)) {
                    customErrorResponse.responsePagePath(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResponseCode", targetDepth)) {
                    customErrorResponse.responseCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ErrorCachingMinTTL", targetDepth)) continue;
                customErrorResponse.errorCachingMinTTL(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CustomErrorResponse)customErrorResponse.build();
    }

    public static CustomErrorResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomErrorResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

