/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.model.CacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.CachedMethods;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.CookiePreference;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.CustomHeaders;
import software.amazon.awssdk.services.cloudfront.model.CustomOriginConfig;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfigWithTags;
import software.amazon.awssdk.services.cloudfront.model.ForwardedValues;
import software.amazon.awssdk.services.cloudfront.model.GeoRestriction;
import software.amazon.awssdk.services.cloudfront.model.Headers;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation;
import software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociations;
import software.amazon.awssdk.services.cloudfront.model.LoggingConfig;
import software.amazon.awssdk.services.cloudfront.model.Origin;
import software.amazon.awssdk.services.cloudfront.model.OriginCustomHeader;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.QueryStringCacheKeys;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.S3OriginConfig;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.services.cloudfront.model.TrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;
import software.amazon.awssdk.util.XmlWriter;

public class CreateDistributionWithTagsRequestMarshaller
implements Marshaller<Request<CreateDistributionWithTagsRequest>, CreateDistributionWithTagsRequest> {
    public Request<CreateDistributionWithTagsRequest> marshall(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        if (createDistributionWithTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDistributionWithTagsRequest, "CloudFrontClient");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2017-03-25/distribution?WithTags";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            DistributionConfigWithTags distributionConfigWithTags = createDistributionWithTagsRequest.distributionConfigWithTags();
            if (distributionConfigWithTags != null) {
                Tags tags;
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2017-03-25/");
                xmlWriter.startElement("DistributionConfigWithTags");
                DistributionConfig distributionConfig = distributionConfigWithTags.distributionConfig();
                if (distributionConfig != null) {
                    Restrictions restrictions;
                    ViewerCertificate viewerCertificate;
                    LoggingConfig logging;
                    CustomErrorResponses customErrorResponses;
                    CacheBehaviors cacheBehaviors;
                    DefaultCacheBehavior defaultCacheBehavior;
                    Origins origins;
                    Aliases aliases;
                    xmlWriter.startElement("DistributionConfig");
                    if (distributionConfig.callerReference() != null) {
                        xmlWriter.startElement("CallerReference").value(distributionConfig.callerReference()).endElement();
                    }
                    if ((aliases = distributionConfig.aliases()) != null) {
                        SdkInternalList aliasesItemsList;
                        xmlWriter.startElement("Aliases");
                        if (aliases.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)aliases.quantity()).endElement();
                        }
                        if (!(aliasesItemsList = (SdkInternalList)aliases.items()).isEmpty() || !aliasesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (Object aliasesItemsListValue : aliasesItemsList) {
                                xmlWriter.startElement("CNAME");
                                xmlWriter.value((String)aliasesItemsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.defaultRootObject() != null) {
                        xmlWriter.startElement("DefaultRootObject").value(distributionConfig.defaultRootObject()).endElement();
                    }
                    if ((origins = distributionConfig.origins()) != null) {
                        SdkInternalList originsItemsList;
                        xmlWriter.startElement("Origins");
                        if (origins.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)origins.quantity()).endElement();
                        }
                        if (!(originsItemsList = (SdkInternalList)origins.items()).isEmpty() || !originsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (Origin originsItemsListValue : originsItemsList) {
                                Object customOriginConfig;
                                S3OriginConfig s3OriginConfig;
                                CustomHeaders customHeaders;
                                xmlWriter.startElement("Origin");
                                if (originsItemsListValue.id() != null) {
                                    xmlWriter.startElement("Id").value(originsItemsListValue.id()).endElement();
                                }
                                if (originsItemsListValue.domainName() != null) {
                                    xmlWriter.startElement("DomainName").value(originsItemsListValue.domainName()).endElement();
                                }
                                if (originsItemsListValue.originPath() != null) {
                                    xmlWriter.startElement("OriginPath").value(originsItemsListValue.originPath()).endElement();
                                }
                                if ((customHeaders = originsItemsListValue.customHeaders()) != null) {
                                    SdkInternalList customHeadersItemsList;
                                    xmlWriter.startElement("CustomHeaders");
                                    if (customHeaders.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)customHeaders.quantity()).endElement();
                                    }
                                    if (!(customHeadersItemsList = (SdkInternalList)customHeaders.items()).isEmpty() || !customHeadersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (OriginCustomHeader customHeadersItemsListValue : customHeadersItemsList) {
                                            xmlWriter.startElement("OriginCustomHeader");
                                            if (customHeadersItemsListValue.headerName() != null) {
                                                xmlWriter.startElement("HeaderName").value(customHeadersItemsListValue.headerName()).endElement();
                                            }
                                            if (customHeadersItemsListValue.headerValue() != null) {
                                                xmlWriter.startElement("HeaderValue").value(customHeadersItemsListValue.headerValue()).endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((s3OriginConfig = originsItemsListValue.s3OriginConfig()) != null) {
                                    xmlWriter.startElement("S3OriginConfig");
                                    if (s3OriginConfig.originAccessIdentity() != null) {
                                        xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfig.originAccessIdentity()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((customOriginConfig = originsItemsListValue.customOriginConfig()) != null) {
                                    OriginSslProtocols originSslProtocols;
                                    xmlWriter.startElement("CustomOriginConfig");
                                    if (((CustomOriginConfig)customOriginConfig).httpPort() != null) {
                                        xmlWriter.startElement("HTTPPort").value((Object)((CustomOriginConfig)customOriginConfig).httpPort()).endElement();
                                    }
                                    if (((CustomOriginConfig)customOriginConfig).httpsPort() != null) {
                                        xmlWriter.startElement("HTTPSPort").value((Object)((CustomOriginConfig)customOriginConfig).httpsPort()).endElement();
                                    }
                                    if (((CustomOriginConfig)customOriginConfig).originProtocolPolicy() != null) {
                                        xmlWriter.startElement("OriginProtocolPolicy").value(((CustomOriginConfig)customOriginConfig).originProtocolPolicy()).endElement();
                                    }
                                    if ((originSslProtocols = ((CustomOriginConfig)customOriginConfig).originSslProtocols()) != null) {
                                        SdkInternalList originSslProtocolsItemsList;
                                        xmlWriter.startElement("OriginSslProtocols");
                                        if (originSslProtocols.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)originSslProtocols.quantity()).endElement();
                                        }
                                        if (!(originSslProtocolsItemsList = (SdkInternalList)originSslProtocols.items()).isEmpty() || !originSslProtocolsItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (Object originSslProtocolsItemsListValue : originSslProtocolsItemsList) {
                                                xmlWriter.startElement("SslProtocol");
                                                xmlWriter.value((String)originSslProtocolsItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if (((CustomOriginConfig)customOriginConfig).originReadTimeout() != null) {
                                        xmlWriter.startElement("OriginReadTimeout").value((Object)((CustomOriginConfig)customOriginConfig).originReadTimeout()).endElement();
                                    }
                                    if (((CustomOriginConfig)customOriginConfig).originKeepaliveTimeout() != null) {
                                        xmlWriter.startElement("OriginKeepaliveTimeout").value((Object)((CustomOriginConfig)customOriginConfig).originKeepaliveTimeout()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((defaultCacheBehavior = distributionConfig.defaultCacheBehavior()) != null) {
                        LambdaFunctionAssociations lambdaFunctionAssociations;
                        Object allowedMethods;
                        TrustedSigners trustedSigners;
                        ForwardedValues forwardedValues;
                        xmlWriter.startElement("DefaultCacheBehavior");
                        if (defaultCacheBehavior.targetOriginId() != null) {
                            xmlWriter.startElement("TargetOriginId").value(defaultCacheBehavior.targetOriginId()).endElement();
                        }
                        if ((forwardedValues = defaultCacheBehavior.forwardedValues()) != null) {
                            Object queryStringCacheKeys;
                            Headers headers;
                            CookiePreference cookies;
                            xmlWriter.startElement("ForwardedValues");
                            if (forwardedValues.queryString() != null) {
                                xmlWriter.startElement("QueryString").value((Object)forwardedValues.queryString()).endElement();
                            }
                            if ((cookies = forwardedValues.cookies()) != null) {
                                CookieNames whitelistedNames;
                                xmlWriter.startElement("Cookies");
                                if (cookies.forward() != null) {
                                    xmlWriter.startElement("Forward").value(cookies.forward()).endElement();
                                }
                                if ((whitelistedNames = cookies.whitelistedNames()) != null) {
                                    SdkInternalList cookieNamesItemsList;
                                    xmlWriter.startElement("WhitelistedNames");
                                    if (whitelistedNames.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)whitelistedNames.quantity()).endElement();
                                    }
                                    if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.items()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                            xmlWriter.startElement("Name");
                                            xmlWriter.value(cookieNamesItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((headers = forwardedValues.headers()) != null) {
                                SdkInternalList headersItemsList;
                                xmlWriter.startElement("Headers");
                                if (headers.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)headers.quantity()).endElement();
                                }
                                if (!(headersItemsList = (SdkInternalList)headers.items()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (Object headersItemsListValue : headersItemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value((String)headersItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((queryStringCacheKeys = forwardedValues.queryStringCacheKeys()) != null) {
                                SdkInternalList queryStringCacheKeysItemsList;
                                xmlWriter.startElement("QueryStringCacheKeys");
                                if (((QueryStringCacheKeys)queryStringCacheKeys).quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)((QueryStringCacheKeys)queryStringCacheKeys).quantity()).endElement();
                                }
                                if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).items()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                    xmlWriter.startElement("Items");
                                    for (Object queryStringCacheKeysItemsListValue : queryStringCacheKeysItemsList) {
                                        xmlWriter.startElement("Name");
                                        xmlWriter.value((String)queryStringCacheKeysItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((trustedSigners = defaultCacheBehavior.trustedSigners()) != null) {
                            SdkInternalList trustedSignersItemsList;
                            xmlWriter.startElement("TrustedSigners");
                            if (trustedSigners.enabled() != null) {
                                xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                            }
                            if (trustedSigners.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                            }
                            if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.items()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (Object trustedSignersItemsListValue : trustedSignersItemsList) {
                                    xmlWriter.startElement("AwsAccountNumber");
                                    xmlWriter.value((String)trustedSignersItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (defaultCacheBehavior.viewerProtocolPolicy() != null) {
                            xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehavior.viewerProtocolPolicy()).endElement();
                        }
                        if (defaultCacheBehavior.minTTL() != null) {
                            xmlWriter.startElement("MinTTL").value((Object)defaultCacheBehavior.minTTL()).endElement();
                        }
                        if ((allowedMethods = defaultCacheBehavior.allowedMethods()) != null) {
                            CachedMethods cachedMethods;
                            SdkInternalList allowedMethodsItemsList;
                            xmlWriter.startElement("AllowedMethods");
                            if (((AllowedMethods)allowedMethods).quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)((AllowedMethods)allowedMethods).quantity()).endElement();
                            }
                            if (!(allowedMethodsItemsList = (SdkInternalList)((AllowedMethods)allowedMethods).items()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                    xmlWriter.startElement("Method");
                                    xmlWriter.value(allowedMethodsItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((cachedMethods = ((AllowedMethods)allowedMethods).cachedMethods()) != null) {
                                Object cachedMethodsItemsList;
                                xmlWriter.startElement("CachedMethods");
                                if (cachedMethods.quantity() != null) {
                                    xmlWriter.startElement("Quantity").value((Object)cachedMethods.quantity()).endElement();
                                }
                                if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.items()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                    Object queryStringCacheKeysItemsListValue;
                                    xmlWriter.startElement("Items");
                                    queryStringCacheKeysItemsListValue = cachedMethodsItemsList.iterator();
                                    while (queryStringCacheKeysItemsListValue.hasNext()) {
                                        String cachedMethodsItemsListValue = (String)queryStringCacheKeysItemsListValue.next();
                                        xmlWriter.startElement("Method");
                                        xmlWriter.value(cachedMethodsItemsListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (defaultCacheBehavior.smoothStreaming() != null) {
                            xmlWriter.startElement("SmoothStreaming").value((Object)defaultCacheBehavior.smoothStreaming()).endElement();
                        }
                        if (defaultCacheBehavior.defaultTTL() != null) {
                            xmlWriter.startElement("DefaultTTL").value((Object)defaultCacheBehavior.defaultTTL()).endElement();
                        }
                        if (defaultCacheBehavior.maxTTL() != null) {
                            xmlWriter.startElement("MaxTTL").value((Object)defaultCacheBehavior.maxTTL()).endElement();
                        }
                        if (defaultCacheBehavior.compress() != null) {
                            xmlWriter.startElement("Compress").value((Object)defaultCacheBehavior.compress()).endElement();
                        }
                        if ((lambdaFunctionAssociations = defaultCacheBehavior.lambdaFunctionAssociations()) != null) {
                            SdkInternalList lambdaFunctionAssociationsItemsList;
                            xmlWriter.startElement("LambdaFunctionAssociations");
                            if (lambdaFunctionAssociations.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.quantity()).endElement();
                            }
                            if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.items()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                    xmlWriter.startElement("LambdaFunctionAssociation");
                                    if (lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN() != null) {
                                        xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN()).endElement();
                                    }
                                    if (lambdaFunctionAssociationsItemsListValue.eventType() != null) {
                                        xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.eventType()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((cacheBehaviors = distributionConfig.cacheBehaviors()) != null) {
                        SdkInternalList cacheBehaviorsItemsList;
                        xmlWriter.startElement("CacheBehaviors");
                        if (cacheBehaviors.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)cacheBehaviors.quantity()).endElement();
                        }
                        if (!(cacheBehaviorsItemsList = (SdkInternalList)cacheBehaviors.items()).isEmpty() || !cacheBehaviorsItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (Object cacheBehaviorsItemsListValue : cacheBehaviorsItemsList) {
                                LambdaFunctionAssociations lambdaFunctionAssociations;
                                AllowedMethods allowedMethods;
                                TrustedSigners trustedSigners;
                                Object queryStringCacheKeys;
                                ForwardedValues forwardedValues;
                                xmlWriter.startElement("CacheBehavior");
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).pathPattern() != null) {
                                    xmlWriter.startElement("PathPattern").value(((CacheBehavior)cacheBehaviorsItemsListValue).pathPattern()).endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).targetOriginId() != null) {
                                    xmlWriter.startElement("TargetOriginId").value(((CacheBehavior)cacheBehaviorsItemsListValue).targetOriginId()).endElement();
                                }
                                if ((forwardedValues = ((CacheBehavior)cacheBehaviorsItemsListValue).forwardedValues()) != null) {
                                    Headers headers;
                                    CookiePreference cookies;
                                    xmlWriter.startElement("ForwardedValues");
                                    if (forwardedValues.queryString() != null) {
                                        xmlWriter.startElement("QueryString").value((Object)forwardedValues.queryString()).endElement();
                                    }
                                    if ((cookies = forwardedValues.cookies()) != null) {
                                        CookieNames whitelistedNames;
                                        xmlWriter.startElement("Cookies");
                                        if (cookies.forward() != null) {
                                            xmlWriter.startElement("Forward").value(cookies.forward()).endElement();
                                        }
                                        if ((whitelistedNames = cookies.whitelistedNames()) != null) {
                                            SdkInternalList cookieNamesItemsList;
                                            xmlWriter.startElement("WhitelistedNames");
                                            if (whitelistedNames.quantity() != null) {
                                                xmlWriter.startElement("Quantity").value((Object)whitelistedNames.quantity()).endElement();
                                            }
                                            if (!(cookieNamesItemsList = (SdkInternalList)whitelistedNames.items()).isEmpty() || !cookieNamesItemsList.isAutoConstruct()) {
                                                xmlWriter.startElement("Items");
                                                for (String cookieNamesItemsListValue : cookieNamesItemsList) {
                                                    xmlWriter.startElement("Name");
                                                    xmlWriter.value(cookieNamesItemsListValue);
                                                    xmlWriter.endElement();
                                                }
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((headers = forwardedValues.headers()) != null) {
                                        SdkInternalList headersItemsList;
                                        xmlWriter.startElement("Headers");
                                        if (headers.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)headers.quantity()).endElement();
                                        }
                                        if (!(headersItemsList = (SdkInternalList)headers.items()).isEmpty() || !headersItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (Object headersItemsListValue : headersItemsList) {
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value((String)headersItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((queryStringCacheKeys = forwardedValues.queryStringCacheKeys()) != null) {
                                        SdkInternalList queryStringCacheKeysItemsList;
                                        xmlWriter.startElement("QueryStringCacheKeys");
                                        if (((QueryStringCacheKeys)queryStringCacheKeys).quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)((QueryStringCacheKeys)queryStringCacheKeys).quantity()).endElement();
                                        }
                                        if (!(queryStringCacheKeysItemsList = (SdkInternalList)((QueryStringCacheKeys)queryStringCacheKeys).items()).isEmpty() || !queryStringCacheKeysItemsList.isAutoConstruct()) {
                                            Object headersItemsListValue;
                                            xmlWriter.startElement("Items");
                                            headersItemsListValue = queryStringCacheKeysItemsList.iterator();
                                            while (headersItemsListValue.hasNext()) {
                                                String queryStringCacheKeysItemsListValue = (String)headersItemsListValue.next();
                                                xmlWriter.startElement("Name");
                                                xmlWriter.value(queryStringCacheKeysItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((trustedSigners = ((CacheBehavior)cacheBehaviorsItemsListValue).trustedSigners()) != null) {
                                    SdkInternalList trustedSignersItemsList;
                                    xmlWriter.startElement("TrustedSigners");
                                    if (trustedSigners.enabled() != null) {
                                        xmlWriter.startElement("Enabled").value((Object)trustedSigners.enabled()).endElement();
                                    }
                                    if (trustedSigners.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)trustedSigners.quantity()).endElement();
                                    }
                                    if (!(trustedSignersItemsList = (SdkInternalList)trustedSigners.items()).isEmpty() || !trustedSignersItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        queryStringCacheKeys = trustedSignersItemsList.iterator();
                                        while (queryStringCacheKeys.hasNext()) {
                                            String trustedSignersItemsListValue = (String)queryStringCacheKeys.next();
                                            xmlWriter.startElement("AwsAccountNumber");
                                            xmlWriter.value(trustedSignersItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).viewerProtocolPolicy() != null) {
                                    xmlWriter.startElement("ViewerProtocolPolicy").value(((CacheBehavior)cacheBehaviorsItemsListValue).viewerProtocolPolicy()).endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).minTTL() != null) {
                                    xmlWriter.startElement("MinTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).minTTL()).endElement();
                                }
                                if ((allowedMethods = ((CacheBehavior)cacheBehaviorsItemsListValue).allowedMethods()) != null) {
                                    CachedMethods cachedMethods;
                                    SdkInternalList allowedMethodsItemsList;
                                    xmlWriter.startElement("AllowedMethods");
                                    if (allowedMethods.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)allowedMethods.quantity()).endElement();
                                    }
                                    if (!(allowedMethodsItemsList = (SdkInternalList)allowedMethods.items()).isEmpty() || !allowedMethodsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (String allowedMethodsItemsListValue : allowedMethodsItemsList) {
                                            xmlWriter.startElement("Method");
                                            xmlWriter.value(allowedMethodsItemsListValue);
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    if ((cachedMethods = allowedMethods.cachedMethods()) != null) {
                                        SdkInternalList cachedMethodsItemsList;
                                        xmlWriter.startElement("CachedMethods");
                                        if (cachedMethods.quantity() != null) {
                                            xmlWriter.startElement("Quantity").value((Object)cachedMethods.quantity()).endElement();
                                        }
                                        if (!(cachedMethodsItemsList = (SdkInternalList)cachedMethods.items()).isEmpty() || !cachedMethodsItemsList.isAutoConstruct()) {
                                            xmlWriter.startElement("Items");
                                            for (String cachedMethodsItemsListValue : cachedMethodsItemsList) {
                                                xmlWriter.startElement("Method");
                                                xmlWriter.value(cachedMethodsItemsListValue);
                                                xmlWriter.endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).smoothStreaming() != null) {
                                    xmlWriter.startElement("SmoothStreaming").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).smoothStreaming()).endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).defaultTTL() != null) {
                                    xmlWriter.startElement("DefaultTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).defaultTTL()).endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).maxTTL() != null) {
                                    xmlWriter.startElement("MaxTTL").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).maxTTL()).endElement();
                                }
                                if (((CacheBehavior)cacheBehaviorsItemsListValue).compress() != null) {
                                    xmlWriter.startElement("Compress").value((Object)((CacheBehavior)cacheBehaviorsItemsListValue).compress()).endElement();
                                }
                                if ((lambdaFunctionAssociations = ((CacheBehavior)cacheBehaviorsItemsListValue).lambdaFunctionAssociations()) != null) {
                                    SdkInternalList lambdaFunctionAssociationsItemsList;
                                    xmlWriter.startElement("LambdaFunctionAssociations");
                                    if (lambdaFunctionAssociations.quantity() != null) {
                                        xmlWriter.startElement("Quantity").value((Object)lambdaFunctionAssociations.quantity()).endElement();
                                    }
                                    if (!(lambdaFunctionAssociationsItemsList = (SdkInternalList)lambdaFunctionAssociations.items()).isEmpty() || !lambdaFunctionAssociationsItemsList.isAutoConstruct()) {
                                        xmlWriter.startElement("Items");
                                        for (LambdaFunctionAssociation lambdaFunctionAssociationsItemsListValue : lambdaFunctionAssociationsItemsList) {
                                            xmlWriter.startElement("LambdaFunctionAssociation");
                                            if (lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN() != null) {
                                                xmlWriter.startElement("LambdaFunctionARN").value(lambdaFunctionAssociationsItemsListValue.lambdaFunctionARN()).endElement();
                                            }
                                            if (lambdaFunctionAssociationsItemsListValue.eventType() != null) {
                                                xmlWriter.startElement("EventType").value(lambdaFunctionAssociationsItemsListValue.eventType()).endElement();
                                            }
                                            xmlWriter.endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((customErrorResponses = distributionConfig.customErrorResponses()) != null) {
                        SdkInternalList customErrorResponsesItemsList;
                        xmlWriter.startElement("CustomErrorResponses");
                        if (customErrorResponses.quantity() != null) {
                            xmlWriter.startElement("Quantity").value((Object)customErrorResponses.quantity()).endElement();
                        }
                        if (!(customErrorResponsesItemsList = (SdkInternalList)customErrorResponses.items()).isEmpty() || !customErrorResponsesItemsList.isAutoConstruct()) {
                            xmlWriter.startElement("Items");
                            for (CustomErrorResponse customErrorResponsesItemsListValue : customErrorResponsesItemsList) {
                                xmlWriter.startElement("CustomErrorResponse");
                                if (customErrorResponsesItemsListValue.errorCode() != null) {
                                    xmlWriter.startElement("ErrorCode").value((Object)customErrorResponsesItemsListValue.errorCode()).endElement();
                                }
                                if (customErrorResponsesItemsListValue.responsePagePath() != null) {
                                    xmlWriter.startElement("ResponsePagePath").value(customErrorResponsesItemsListValue.responsePagePath()).endElement();
                                }
                                if (customErrorResponsesItemsListValue.responseCode() != null) {
                                    xmlWriter.startElement("ResponseCode").value(customErrorResponsesItemsListValue.responseCode()).endElement();
                                }
                                if (customErrorResponsesItemsListValue.errorCachingMinTTL() != null) {
                                    xmlWriter.startElement("ErrorCachingMinTTL").value((Object)customErrorResponsesItemsListValue.errorCachingMinTTL()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.comment() != null) {
                        xmlWriter.startElement("Comment").value(distributionConfig.comment()).endElement();
                    }
                    if ((logging = distributionConfig.logging()) != null) {
                        xmlWriter.startElement("Logging");
                        if (logging.enabled() != null) {
                            xmlWriter.startElement("Enabled").value((Object)logging.enabled()).endElement();
                        }
                        if (logging.includeCookies() != null) {
                            xmlWriter.startElement("IncludeCookies").value((Object)logging.includeCookies()).endElement();
                        }
                        if (logging.bucket() != null) {
                            xmlWriter.startElement("Bucket").value(logging.bucket()).endElement();
                        }
                        if (logging.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(logging.prefix()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.priceClass() != null) {
                        xmlWriter.startElement("PriceClass").value(distributionConfig.priceClass()).endElement();
                    }
                    if (distributionConfig.enabled() != null) {
                        xmlWriter.startElement("Enabled").value((Object)distributionConfig.enabled()).endElement();
                    }
                    if ((viewerCertificate = distributionConfig.viewerCertificate()) != null) {
                        xmlWriter.startElement("ViewerCertificate");
                        if (viewerCertificate.cloudFrontDefaultCertificate() != null) {
                            xmlWriter.startElement("CloudFrontDefaultCertificate").value((Object)viewerCertificate.cloudFrontDefaultCertificate()).endElement();
                        }
                        if (viewerCertificate.iamCertificateId() != null) {
                            xmlWriter.startElement("IAMCertificateId").value(viewerCertificate.iamCertificateId()).endElement();
                        }
                        if (viewerCertificate.acmCertificateArn() != null) {
                            xmlWriter.startElement("ACMCertificateArn").value(viewerCertificate.acmCertificateArn()).endElement();
                        }
                        if (viewerCertificate.sslSupportMethod() != null) {
                            xmlWriter.startElement("SSLSupportMethod").value(viewerCertificate.sslSupportMethod()).endElement();
                        }
                        if (viewerCertificate.minimumProtocolVersion() != null) {
                            xmlWriter.startElement("MinimumProtocolVersion").value(viewerCertificate.minimumProtocolVersion()).endElement();
                        }
                        if (viewerCertificate.certificate() != null) {
                            xmlWriter.startElement("Certificate").value(viewerCertificate.certificate()).endElement();
                        }
                        if (viewerCertificate.certificateSource() != null) {
                            xmlWriter.startElement("CertificateSource").value(viewerCertificate.certificateSource()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((restrictions = distributionConfig.restrictions()) != null) {
                        xmlWriter.startElement("Restrictions");
                        GeoRestriction geoRestriction = restrictions.geoRestriction();
                        if (geoRestriction != null) {
                            SdkInternalList geoRestrictionItemsList;
                            xmlWriter.startElement("GeoRestriction");
                            if (geoRestriction.restrictionType() != null) {
                                xmlWriter.startElement("RestrictionType").value(geoRestriction.restrictionType()).endElement();
                            }
                            if (geoRestriction.quantity() != null) {
                                xmlWriter.startElement("Quantity").value((Object)geoRestriction.quantity()).endElement();
                            }
                            if (!(geoRestrictionItemsList = (SdkInternalList)geoRestriction.items()).isEmpty() || !geoRestrictionItemsList.isAutoConstruct()) {
                                xmlWriter.startElement("Items");
                                for (String geoRestrictionItemsListValue : geoRestrictionItemsList) {
                                    xmlWriter.startElement("Location");
                                    xmlWriter.value(geoRestrictionItemsListValue);
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (distributionConfig.webACLId() != null) {
                        xmlWriter.startElement("WebACLId").value(distributionConfig.webACLId()).endElement();
                    }
                    if (distributionConfig.httpVersion() != null) {
                        xmlWriter.startElement("HttpVersion").value(distributionConfig.httpVersion()).endElement();
                    }
                    if (distributionConfig.isIPV6Enabled() != null) {
                        xmlWriter.startElement("IsIPV6Enabled").value((Object)distributionConfig.isIPV6Enabled()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((tags = distributionConfigWithTags.tags()) != null) {
                    xmlWriter.startElement("Tags");
                    SdkInternalList tagsItemsList = (SdkInternalList)tags.items();
                    if (!tagsItemsList.isEmpty() || !tagsItemsList.isAutoConstruct()) {
                        xmlWriter.startElement("Items");
                        for (Tag tagsItemsListValue : tagsItemsList) {
                            xmlWriter.startElement("Tag");
                            if (tagsItemsListValue.key() != null) {
                                xmlWriter.startElement("Key").value(tagsItemsListValue.key()).endElement();
                            }
                            if (tagsItemsListValue.value() != null) {
                                xmlWriter.startElement("Value").value(tagsItemsListValue.value()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

