/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity;
import software.amazon.awssdk.services.cloudfront.transform.CloudFrontOriginAccessIdentityConfigUnmarshaller;

public class CloudFrontOriginAccessIdentityUnmarshaller
implements Unmarshaller<CloudFrontOriginAccessIdentity, StaxUnmarshallerContext> {
    private static CloudFrontOriginAccessIdentityUnmarshaller INSTANCE;

    public CloudFrontOriginAccessIdentity unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CloudFrontOriginAccessIdentity.Builder cloudFrontOriginAccessIdentity = CloudFrontOriginAccessIdentity.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    cloudFrontOriginAccessIdentity.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3CanonicalUserId", targetDepth)) {
                    cloudFrontOriginAccessIdentity.s3CanonicalUserId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudFrontOriginAccessIdentityConfig", targetDepth)) continue;
                cloudFrontOriginAccessIdentity.cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfigUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CloudFrontOriginAccessIdentity)cloudFrontOriginAccessIdentity.build();
    }

    public static CloudFrontOriginAccessIdentityUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudFrontOriginAccessIdentityUnmarshaller();
        }
        return INSTANCE;
    }
}

