/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.Signer;
import software.amazon.awssdk.services.cloudfront.transform.SignerUnmarshaller;

public class ActiveTrustedSignersUnmarshaller
implements Unmarshaller<ActiveTrustedSigners, StaxUnmarshallerContext> {
    private static ActiveTrustedSignersUnmarshaller INSTANCE;

    public ActiveTrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ActiveTrustedSigners.Builder activeTrustedSigners = ActiveTrustedSigners.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    activeTrustedSigners.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    activeTrustedSigners.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    activeTrustedSigners.items(new ArrayList<Signer>());
                    continue;
                }
                if (!context.testExpression("Items/Signer", targetDepth)) continue;
                activeTrustedSigners.items(SignerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ActiveTrustedSigners)activeTrustedSigners.build();
    }

    public static ActiveTrustedSignersUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActiveTrustedSignersUnmarshaller();
        }
        return INSTANCE;
    }
}

