/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudfront.model.Method;
import software.amazon.awssdk.services.cloudfront.model.MethodsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CachedMethods
implements ToCopyableBuilder<Builder, CachedMethods> {
    private final Integer quantity;
    private final List<String> items;

    private CachedMethods(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<String> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachedMethods)) {
            return false;
        }
        CachedMethods other = (CachedMethods)obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<String> items = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CachedMethods model) {
            this.setQuantity(model.quantity);
            this.setItems(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Method ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Method ele : items) {
                this.items.add(ele.toString());
            }
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(String ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (String e : items) {
                this.items.add(e);
            }
        }

        @SafeVarargs
        public final void setItems(Method ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Method ele : items) {
                this.items.add(ele.toString());
            }
        }

        public CachedMethods build() {
            return new CachedMethods(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CachedMethods> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<String> var1);

        public Builder items(String ... var1);

        public Builder items(Method ... var1);
    }
}

