/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackResourceDriftInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackResourceDriftInformation> {
    private static final SdkField<String> STACK_RESOURCE_DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDriftInformation.getter(StackResourceDriftInformation::stackResourceDriftStatusAsString)).setter(StackResourceDriftInformation.setter(Builder::stackResourceDriftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDriftStatus").build()}).build();
    private static final SdkField<Instant> LAST_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StackResourceDriftInformation.getter(StackResourceDriftInformation::lastCheckTimestamp)).setter(StackResourceDriftInformation.setter(Builder::lastCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFT_STATUS_FIELD, LAST_CHECK_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackResourceDriftStatus;
    private final Instant lastCheckTimestamp;

    private StackResourceDriftInformation(BuilderImpl builder) {
        this.stackResourceDriftStatus = builder.stackResourceDriftStatus;
        this.lastCheckTimestamp = builder.lastCheckTimestamp;
    }

    public StackResourceDriftStatus stackResourceDriftStatus() {
        return StackResourceDriftStatus.fromValue(this.stackResourceDriftStatus);
    }

    public String stackResourceDriftStatusAsString() {
        return this.stackResourceDriftStatus;
    }

    public Instant lastCheckTimestamp() {
        return this.lastCheckTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResourceDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceDriftInformation)) {
            return false;
        }
        StackResourceDriftInformation other = (StackResourceDriftInformation)obj;
        return Objects.equals(this.stackResourceDriftStatusAsString(), other.stackResourceDriftStatusAsString()) && Objects.equals(this.lastCheckTimestamp(), other.lastCheckTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"StackResourceDriftInformation").add("StackResourceDriftStatus", (Object)this.stackResourceDriftStatusAsString()).add("LastCheckTimestamp", (Object)this.lastCheckTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResourceDriftStatus": {
                return Optional.ofNullable(clazz.cast(this.stackResourceDriftStatusAsString()));
            }
            case "LastCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackResourceDriftInformation, T> g) {
        return obj -> g.apply((StackResourceDriftInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackResourceDriftStatus;
        private Instant lastCheckTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceDriftInformation model) {
            this.stackResourceDriftStatus(model.stackResourceDriftStatus);
            this.lastCheckTimestamp(model.lastCheckTimestamp);
        }

        public final String getStackResourceDriftStatusAsString() {
            return this.stackResourceDriftStatus;
        }

        @Override
        public final Builder stackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
            return this;
        }

        @Override
        public final Builder stackResourceDriftStatus(StackResourceDriftStatus stackResourceDriftStatus) {
            this.stackResourceDriftStatus(stackResourceDriftStatus.toString());
            return this;
        }

        public final void setStackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
        }

        public final Instant getLastCheckTimestamp() {
            return this.lastCheckTimestamp;
        }

        @Override
        public final Builder lastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
            return this;
        }

        public final void setLastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
        }

        public StackResourceDriftInformation build() {
            return new StackResourceDriftInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackResourceDriftInformation> {
        public Builder stackResourceDriftStatus(String var1);

        public Builder stackResourceDriftStatus(StackResourceDriftStatus var1);

        public Builder lastCheckTimestamp(Instant var1);
    }
}

