/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnnotationSeverityLevel {
    INFORMATIONAL("INFORMATIONAL"),
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    CRITICAL("CRITICAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnnotationSeverityLevel> VALUE_MAP;
    private final String value;

    private AnnotationSeverityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnnotationSeverityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnnotationSeverityLevel> knownValues() {
        EnumSet<AnnotationSeverityLevel> knownValues = EnumSet.allOf(AnnotationSeverityLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnnotationSeverityLevel.class, AnnotationSeverityLevel::toString);
    }
}

