/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ResourceDriftIgnoredAttribute</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDriftIgnoredAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDriftIgnoredAttribute.Builder, ResourceDriftIgnoredAttribute> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(ResourceDriftIgnoredAttribute::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ResourceDriftIgnoredAttribute::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String reason;

    private ResourceDriftIgnoredAttribute(BuilderImpl builder) {
        this.path = builder.path;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Path of the resource attribute for which drift was ignored.
     * </p>
     * 
     * @return Path of the resource attribute for which drift was ignored.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * Reason why drift was ignored for the attribute, can have 2 possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
     * dynamically modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link DriftIgnoredReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason why drift was ignored for the attribute, can have 2 possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live
     *         state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
     *         dynamically modified.
     *         </p>
     *         </li>
     * @see DriftIgnoredReason
     */
    public final DriftIgnoredReason reason() {
        return DriftIgnoredReason.fromValue(reason);
    }

    /**
     * <p>
     * Reason why drift was ignored for the attribute, can have 2 possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
     * dynamically modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link DriftIgnoredReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason why drift was ignored for the attribute, can have 2 possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live
     *         state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
     *         dynamically modified.
     *         </p>
     *         </li>
     * @see DriftIgnoredReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDriftIgnoredAttribute)) {
            return false;
        }
        ResourceDriftIgnoredAttribute other = (ResourceDriftIgnoredAttribute) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDriftIgnoredAttribute").add("Path", path()).add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Path", PATH_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceDriftIgnoredAttribute, T> g) {
        return obj -> g.apply((ResourceDriftIgnoredAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDriftIgnoredAttribute> {
        /**
         * <p>
         * Path of the resource attribute for which drift was ignored.
         * </p>
         * 
         * @param path
         *        Path of the resource attribute for which drift was ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Reason why drift was ignored for the attribute, can have 2 possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
         * dynamically modified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        Reason why drift was ignored for the attribute, can have 2 possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to
         *        be dynamically modified.
         *        </p>
         *        </li>
         * @see DriftIgnoredReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftIgnoredReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Reason why drift was ignored for the attribute, can have 2 possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to be
         * dynamically modified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        Reason why drift was ignored for the attribute, can have 2 possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WRITE_ONLY_PROPERTY</code> - Property is not included in read response for the resource’s live
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED_BY_AWS</code> - Property is managed by an Amazon Web Services service and is expected to
         *        be dynamically modified.
         *        </p>
         *        </li>
         * @see DriftIgnoredReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftIgnoredReason
         */
        Builder reason(DriftIgnoredReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDriftIgnoredAttribute model) {
            path(model.path);
            reason(model.reason);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(DriftIgnoredReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public ResourceDriftIgnoredAttribute build() {
            return new ResourceDriftIgnoredAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
