/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LastOperationsCopier {
    static List<OperationEntry> copy(Collection<? extends OperationEntry> lastOperationsParam) {
        List<OperationEntry> list;
        if (lastOperationsParam == null || lastOperationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OperationEntry> modifiableList = new ArrayList<>(lastOperationsParam.size());
            lastOperationsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OperationEntry> copyFromBuilder(Collection<? extends OperationEntry.Builder> lastOperationsParam) {
        List<OperationEntry> list;
        if (lastOperationsParam == null || lastOperationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OperationEntry> modifiableList = new ArrayList<>(lastOperationsParam.size());
            lastOperationsParam.forEach(entry -> {
                OperationEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<OperationEntry.Builder> copyToBuilder(Collection<? extends OperationEntry> lastOperationsParam) {
        List<OperationEntry.Builder> list;
        if (lastOperationsParam == null || lastOperationsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<OperationEntry.Builder> modifiableList = new ArrayList<>(lastOperationsParam.size());
            lastOperationsParam.forEach(entry -> {
                OperationEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
