/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>DescribeStackResources</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStackResourcesResponse extends CloudFormationResponse implements
        ToCopyableBuilder<DescribeStackResourcesResponse.Builder, DescribeStackResourcesResponse> {
    private static final SdkField<List<StackResource>> STACK_RESOURCES_FIELD = SdkField
            .<List<StackResource>> builder(MarshallingType.LIST)
            .memberName("StackResources")
            .getter(getter(DescribeStackResourcesResponse::stackResources))
            .setter(setter(Builder::stackResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StackResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(StackResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<StackResource> stackResources;

    private DescribeStackResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.stackResources = builder.stackResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackResources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStackResources() {
        return stackResources != null && !(stackResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>StackResource</code> structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackResources} method.
     * </p>
     * 
     * @return A list of <code>StackResource</code> structures.
     */
    public final List<StackResource> stackResources() {
        return stackResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackResources() ? stackResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesResponse)) {
            return false;
        }
        DescribeStackResourcesResponse other = (DescribeStackResourcesResponse) obj;
        return hasStackResources() == other.hasStackResources() && Objects.equals(stackResources(), other.stackResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStackResourcesResponse")
                .add("StackResources", hasStackResources() ? stackResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackResources":
            return Optional.ofNullable(clazz.cast(stackResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackResources", STACK_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourcesResponse, T> g) {
        return obj -> g.apply((DescribeStackResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStackResourcesResponse> {
        /**
         * <p>
         * A list of <code>StackResource</code> structures.
         * </p>
         * 
         * @param stackResources
         *        A list of <code>StackResource</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResources(Collection<StackResource> stackResources);

        /**
         * <p>
         * A list of <code>StackResource</code> structures.
         * </p>
         * 
         * @param stackResources
         *        A list of <code>StackResource</code> structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackResources(StackResource... stackResources);

        /**
         * <p>
         * A list of <code>StackResource</code> structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.StackResource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cloudformation.model.StackResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.StackResource.Builder#build()} is called
         * immediately and its result is passed to {@link #stackResources(List<StackResource>)}.
         * 
         * @param stackResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.StackResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stackResources(java.util.Collection<StackResource>)
         */
        Builder stackResources(Consumer<StackResource.Builder>... stackResources);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private List<StackResource> stackResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesResponse model) {
            super(model);
            stackResources(model.stackResources);
        }

        public final List<StackResource.Builder> getStackResources() {
            List<StackResource.Builder> result = StackResourcesCopier.copyToBuilder(this.stackResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackResources(Collection<StackResource.BuilderImpl> stackResources) {
            this.stackResources = StackResourcesCopier.copyFromBuilder(stackResources);
        }

        @Override
        public final Builder stackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(StackResource... stackResources) {
            stackResources(Arrays.asList(stackResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(Consumer<StackResource.Builder>... stackResources) {
            stackResources(Stream.of(stackResources).map(c -> StackResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeStackResourcesResponse build() {
            return new DescribeStackResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
