/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for a <a>CreateStack</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStackResponse extends CloudFormationResponse implements
        ToCopyableBuilder<CreateStackResponse.Builder, CreateStackResponse> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(CreateStackResponse::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(CreateStackResponse::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            OPERATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackId;

    private final String operationId;

    private CreateStackResponse(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * A unique identifier for this stack operation that can be used to track the operation's progress and events.
     * </p>
     * 
     * @return A unique identifier for this stack operation that can be used to track the operation's progress and
     *         events.
     */
    public final String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackResponse)) {
            return false;
        }
        CreateStackResponse other = (CreateStackResponse) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(operationId(), other.operationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStackResponse").add("StackId", stackId()).add("OperationId", operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStackResponse, T> g) {
        return obj -> g.apply((CreateStackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateStackResponse> {
        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * A unique identifier for this stack operation that can be used to track the operation's progress and events.
         * </p>
         * 
         * @param operationId
         *        A unique identifier for this stack operation that can be used to track the operation's progress and
         *        events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String stackId;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackResponse model) {
            super(model);
            stackId(model.stackId);
            operationId(model.operationId);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public CreateStackResponse build() {
            return new CreateStackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
