/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackResourceDriftInformationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackResourceDriftInformationSummary> {
    private static final SdkField<String> STACK_RESOURCE_DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackResourceDriftStatus").getter(StackResourceDriftInformationSummary.getter(StackResourceDriftInformationSummary::stackResourceDriftStatusAsString)).setter(StackResourceDriftInformationSummary.setter(Builder::stackResourceDriftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDriftStatus").build()}).build();
    private static final SdkField<Instant> LAST_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckTimestamp").getter(StackResourceDriftInformationSummary.getter(StackResourceDriftInformationSummary::lastCheckTimestamp)).setter(StackResourceDriftInformationSummary.setter(Builder::lastCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_RESOURCE_DRIFT_STATUS_FIELD, LAST_CHECK_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StackResourceDriftInformationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stackResourceDriftStatus;
    private final Instant lastCheckTimestamp;

    private StackResourceDriftInformationSummary(BuilderImpl builder) {
        this.stackResourceDriftStatus = builder.stackResourceDriftStatus;
        this.lastCheckTimestamp = builder.lastCheckTimestamp;
    }

    public final StackResourceDriftStatus stackResourceDriftStatus() {
        return StackResourceDriftStatus.fromValue(this.stackResourceDriftStatus);
    }

    public final String stackResourceDriftStatusAsString() {
        return this.stackResourceDriftStatus;
    }

    public final Instant lastCheckTimestamp() {
        return this.lastCheckTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResourceDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceDriftInformationSummary)) {
            return false;
        }
        StackResourceDriftInformationSummary other = (StackResourceDriftInformationSummary)obj;
        return Objects.equals(this.stackResourceDriftStatusAsString(), other.stackResourceDriftStatusAsString()) && Objects.equals(this.lastCheckTimestamp(), other.lastCheckTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StackResourceDriftInformationSummary").add("StackResourceDriftStatus", (Object)this.stackResourceDriftStatusAsString()).add("LastCheckTimestamp", (Object)this.lastCheckTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackResourceDriftStatus": {
                return Optional.ofNullable(clazz.cast(this.stackResourceDriftStatusAsString()));
            }
            case "LastCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackResourceDriftStatus", STACK_RESOURCE_DRIFT_STATUS_FIELD);
        map.put("LastCheckTimestamp", LAST_CHECK_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackResourceDriftInformationSummary, T> g) {
        return obj -> g.apply((StackResourceDriftInformationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackResourceDriftStatus;
        private Instant lastCheckTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceDriftInformationSummary model) {
            this.stackResourceDriftStatus(model.stackResourceDriftStatus);
            this.lastCheckTimestamp(model.lastCheckTimestamp);
        }

        public final String getStackResourceDriftStatus() {
            return this.stackResourceDriftStatus;
        }

        public final void setStackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
        }

        @Override
        public final Builder stackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
            return this;
        }

        @Override
        public final Builder stackResourceDriftStatus(StackResourceDriftStatus stackResourceDriftStatus) {
            this.stackResourceDriftStatus(stackResourceDriftStatus == null ? null : stackResourceDriftStatus.toString());
            return this;
        }

        public final Instant getLastCheckTimestamp() {
            return this.lastCheckTimestamp;
        }

        public final void setLastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
        }

        @Override
        public final Builder lastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
            return this;
        }

        public StackResourceDriftInformationSummary build() {
            return new StackResourceDriftInformationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackResourceDriftInformationSummary> {
        public Builder stackResourceDriftStatus(String var1);

        public Builder stackResourceDriftStatus(StackResourceDriftStatus var1);

        public Builder lastCheckTimestamp(Instant var1);
    }
}

