/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus;
import software.amazon.awssdk.services.cloudformation.model.LoggingConfig;
import software.amazon.awssdk.services.cloudformation.model.ProvisioningType;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.services.cloudformation.model.RequiredActivatedType;
import software.amazon.awssdk.services.cloudformation.model.RequiredActivatedTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.TypeTestsStatus;
import software.amazon.awssdk.services.cloudformation.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTypeResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribeTypeResponse.getter(DescribeTypeResponse::arn)).setter(DescribeTypeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeAsString)).setter(DescribeTypeResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeName)).setter(DescribeTypeResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultVersionId").getter(DescribeTypeResponse.getter(DescribeTypeResponse::defaultVersionId)).setter(DescribeTypeResponse.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefaultVersion").getter(DescribeTypeResponse.getter(DescribeTypeResponse::isDefaultVersion)).setter(DescribeTypeResponse.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()}).build();
    private static final SdkField<String> TYPE_TESTS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeTestsStatus").getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeTestsStatusAsString)).setter(DescribeTypeResponse.setter(Builder::typeTestsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeTestsStatus").build()}).build();
    private static final SdkField<String> TYPE_TESTS_STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeTestsStatusDescription").getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeTestsStatusDescription)).setter(DescribeTypeResponse.setter(Builder::typeTestsStatusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeTestsStatusDescription").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeTypeResponse.getter(DescribeTypeResponse::description)).setter(DescribeTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(DescribeTypeResponse.getter(DescribeTypeResponse::schema)).setter(DescribeTypeResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningType").getter(DescribeTypeResponse.getter(DescribeTypeResponse::provisioningTypeAsString)).setter(DescribeTypeResponse.setter(Builder::provisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()}).build();
    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeprecatedStatus").getter(DescribeTypeResponse.getter(DescribeTypeResponse::deprecatedStatusAsString)).setter(DescribeTypeResponse.setter(Builder::deprecatedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfig").getter(DescribeTypeResponse.getter(DescribeTypeResponse::loggingConfig)).setter(DescribeTypeResponse.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final SdkField<List<RequiredActivatedType>> REQUIRED_ACTIVATED_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredActivatedTypes").getter(DescribeTypeResponse.getter(DescribeTypeResponse::requiredActivatedTypes)).setter(DescribeTypeResponse.setter(Builder::requiredActivatedTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredActivatedTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequiredActivatedType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(DescribeTypeResponse.getter(DescribeTypeResponse::executionRoleArn)).setter(DescribeTypeResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(DescribeTypeResponse.getter(DescribeTypeResponse::visibilityAsString)).setter(DescribeTypeResponse.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUrl").getter(DescribeTypeResponse.getter(DescribeTypeResponse::sourceUrl)).setter(DescribeTypeResponse.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()}).build();
    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentationUrl").getter(DescribeTypeResponse.getter(DescribeTypeResponse::documentationUrl)).setter(DescribeTypeResponse.setter(Builder::documentationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationUrl").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(DescribeTypeResponse.getter(DescribeTypeResponse::lastUpdated)).setter(DescribeTypeResponse.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeCreated").getter(DescribeTypeResponse.getter(DescribeTypeResponse::timeCreated)).setter(DescribeTypeResponse.setter(Builder::timeCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()}).build();
    private static final SdkField<String> CONFIGURATION_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationSchema").getter(DescribeTypeResponse.getter(DescribeTypeResponse::configurationSchema)).setter(DescribeTypeResponse.setter(Builder::configurationSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSchema").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(DescribeTypeResponse.getter(DescribeTypeResponse::publisherId)).setter(DescribeTypeResponse.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalTypeName").getter(DescribeTypeResponse.getter(DescribeTypeResponse::originalTypeName)).setter(DescribeTypeResponse.setter(Builder::originalTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()}).build();
    private static final SdkField<String> ORIGINAL_TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalTypeArn").getter(DescribeTypeResponse.getter(DescribeTypeResponse::originalTypeArn)).setter(DescribeTypeResponse.setter(Builder::originalTypeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeArn").build()}).build();
    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicVersionNumber").getter(DescribeTypeResponse.getter(DescribeTypeResponse::publicVersionNumber)).setter(DescribeTypeResponse.setter(Builder::publicVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build()}).build();
    private static final SdkField<String> LATEST_PUBLIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestPublicVersion").getter(DescribeTypeResponse.getter(DescribeTypeResponse::latestPublicVersion)).setter(DescribeTypeResponse.setter(Builder::latestPublicVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestPublicVersion").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsActivated").getter(DescribeTypeResponse.getter(DescribeTypeResponse::isActivated)).setter(DescribeTypeResponse.setter(Builder::isActivated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActivated").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoUpdate").getter(DescribeTypeResponse.getter(DescribeTypeResponse::autoUpdate)).setter(DescribeTypeResponse.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, TYPE_TESTS_STATUS_FIELD, TYPE_TESTS_STATUS_DESCRIPTION_FIELD, DESCRIPTION_FIELD, SCHEMA_FIELD, PROVISIONING_TYPE_FIELD, DEPRECATED_STATUS_FIELD, LOGGING_CONFIG_FIELD, REQUIRED_ACTIVATED_TYPES_FIELD, EXECUTION_ROLE_ARN_FIELD, VISIBILITY_FIELD, SOURCE_URL_FIELD, DOCUMENTATION_URL_FIELD, LAST_UPDATED_FIELD, TIME_CREATED_FIELD, CONFIGURATION_SCHEMA_FIELD, PUBLISHER_ID_FIELD, ORIGINAL_TYPE_NAME_FIELD, ORIGINAL_TYPE_ARN_FIELD, PUBLIC_VERSION_NUMBER_FIELD, LATEST_PUBLIC_VERSION_FIELD, IS_ACTIVATED_FIELD, AUTO_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTypeResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String type;
    private final String typeName;
    private final String defaultVersionId;
    private final Boolean isDefaultVersion;
    private final String typeTestsStatus;
    private final String typeTestsStatusDescription;
    private final String description;
    private final String schema;
    private final String provisioningType;
    private final String deprecatedStatus;
    private final LoggingConfig loggingConfig;
    private final List<RequiredActivatedType> requiredActivatedTypes;
    private final String executionRoleArn;
    private final String visibility;
    private final String sourceUrl;
    private final String documentationUrl;
    private final Instant lastUpdated;
    private final Instant timeCreated;
    private final String configurationSchema;
    private final String publisherId;
    private final String originalTypeName;
    private final String originalTypeArn;
    private final String publicVersionNumber;
    private final String latestPublicVersion;
    private final Boolean isActivated;
    private final Boolean autoUpdate;

    private DescribeTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.typeTestsStatus = builder.typeTestsStatus;
        this.typeTestsStatusDescription = builder.typeTestsStatusDescription;
        this.description = builder.description;
        this.schema = builder.schema;
        this.provisioningType = builder.provisioningType;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.loggingConfig = builder.loggingConfig;
        this.requiredActivatedTypes = builder.requiredActivatedTypes;
        this.executionRoleArn = builder.executionRoleArn;
        this.visibility = builder.visibility;
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.lastUpdated = builder.lastUpdated;
        this.timeCreated = builder.timeCreated;
        this.configurationSchema = builder.configurationSchema;
        this.publisherId = builder.publisherId;
        this.originalTypeName = builder.originalTypeName;
        this.originalTypeArn = builder.originalTypeArn;
        this.publicVersionNumber = builder.publicVersionNumber;
        this.latestPublicVersion = builder.latestPublicVersion;
        this.isActivated = builder.isActivated;
        this.autoUpdate = builder.autoUpdate;
    }

    public final String arn() {
        return this.arn;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String defaultVersionId() {
        return this.defaultVersionId;
    }

    public final Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public final TypeTestsStatus typeTestsStatus() {
        return TypeTestsStatus.fromValue(this.typeTestsStatus);
    }

    public final String typeTestsStatusAsString() {
        return this.typeTestsStatus;
    }

    public final String typeTestsStatusDescription() {
        return this.typeTestsStatusDescription;
    }

    public final String description() {
        return this.description;
    }

    public final String schema() {
        return this.schema;
    }

    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(this.provisioningType);
    }

    public final String provisioningTypeAsString() {
        return this.provisioningType;
    }

    public final DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(this.deprecatedStatus);
    }

    public final String deprecatedStatusAsString() {
        return this.deprecatedStatus;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final boolean hasRequiredActivatedTypes() {
        return this.requiredActivatedTypes != null && !(this.requiredActivatedTypes instanceof SdkAutoConstructList);
    }

    public final List<RequiredActivatedType> requiredActivatedTypes() {
        return this.requiredActivatedTypes;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final String sourceUrl() {
        return this.sourceUrl;
    }

    public final String documentationUrl() {
        return this.documentationUrl;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Instant timeCreated() {
        return this.timeCreated;
    }

    public final String configurationSchema() {
        return this.configurationSchema;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final String originalTypeName() {
        return this.originalTypeName;
    }

    public final String originalTypeArn() {
        return this.originalTypeArn;
    }

    public final String publicVersionNumber() {
        return this.publicVersionNumber;
    }

    public final String latestPublicVersion() {
        return this.latestPublicVersion;
    }

    public final Boolean isActivated() {
        return this.isActivated;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeTestsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeTestsStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredActivatedTypes() ? this.requiredActivatedTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestPublicVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActivated());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeResponse)) {
            return false;
        }
        DescribeTypeResponse other = (DescribeTypeResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.typeTestsStatusAsString(), other.typeTestsStatusAsString()) && Objects.equals(this.typeTestsStatusDescription(), other.typeTestsStatusDescription()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.provisioningTypeAsString(), other.provisioningTypeAsString()) && Objects.equals(this.deprecatedStatusAsString(), other.deprecatedStatusAsString()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && this.hasRequiredActivatedTypes() == other.hasRequiredActivatedTypes() && Objects.equals(this.requiredActivatedTypes(), other.requiredActivatedTypes()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && Objects.equals(this.documentationUrl(), other.documentationUrl()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.timeCreated(), other.timeCreated()) && Objects.equals(this.configurationSchema(), other.configurationSchema()) && Objects.equals(this.publisherId(), other.publisherId()) && Objects.equals(this.originalTypeName(), other.originalTypeName()) && Objects.equals(this.originalTypeArn(), other.originalTypeArn()) && Objects.equals(this.publicVersionNumber(), other.publicVersionNumber()) && Objects.equals(this.latestPublicVersion(), other.latestPublicVersion()) && Objects.equals(this.isActivated(), other.isActivated()) && Objects.equals(this.autoUpdate(), other.autoUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTypeResponse").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("TypeTestsStatus", (Object)this.typeTestsStatusAsString()).add("TypeTestsStatusDescription", (Object)this.typeTestsStatusDescription()).add("Description", (Object)this.description()).add("Schema", (Object)this.schema()).add("ProvisioningType", (Object)this.provisioningTypeAsString()).add("DeprecatedStatus", (Object)this.deprecatedStatusAsString()).add("LoggingConfig", (Object)this.loggingConfig()).add("RequiredActivatedTypes", this.hasRequiredActivatedTypes() ? this.requiredActivatedTypes() : null).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Visibility", (Object)this.visibilityAsString()).add("SourceUrl", (Object)this.sourceUrl()).add("DocumentationUrl", (Object)this.documentationUrl()).add("LastUpdated", (Object)this.lastUpdated()).add("TimeCreated", (Object)this.timeCreated()).add("ConfigurationSchema", (Object)this.configurationSchema()).add("PublisherId", (Object)this.publisherId()).add("OriginalTypeName", (Object)this.originalTypeName()).add("OriginalTypeArn", (Object)this.originalTypeArn()).add("PublicVersionNumber", (Object)this.publicVersionNumber()).add("LatestPublicVersion", (Object)this.latestPublicVersion()).add("IsActivated", (Object)this.isActivated()).add("AutoUpdate", (Object)this.autoUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "IsDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "TypeTestsStatus": {
                return Optional.ofNullable(clazz.cast(this.typeTestsStatusAsString()));
            }
            case "TypeTestsStatusDescription": {
                return Optional.ofNullable(clazz.cast(this.typeTestsStatusDescription()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "ProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.provisioningTypeAsString()));
            }
            case "DeprecatedStatus": {
                return Optional.ofNullable(clazz.cast(this.deprecatedStatusAsString()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "RequiredActivatedTypes": {
                return Optional.ofNullable(clazz.cast(this.requiredActivatedTypes()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "SourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "DocumentationUrl": {
                return Optional.ofNullable(clazz.cast(this.documentationUrl()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "TimeCreated": {
                return Optional.ofNullable(clazz.cast(this.timeCreated()));
            }
            case "ConfigurationSchema": {
                return Optional.ofNullable(clazz.cast(this.configurationSchema()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "OriginalTypeName": {
                return Optional.ofNullable(clazz.cast(this.originalTypeName()));
            }
            case "OriginalTypeArn": {
                return Optional.ofNullable(clazz.cast(this.originalTypeArn()));
            }
            case "PublicVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.publicVersionNumber()));
            }
            case "LatestPublicVersion": {
                return Optional.ofNullable(clazz.cast(this.latestPublicVersion()));
            }
            case "IsActivated": {
                return Optional.ofNullable(clazz.cast(this.isActivated()));
            }
            case "AutoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("DefaultVersionId", DEFAULT_VERSION_ID_FIELD);
        map.put("IsDefaultVersion", IS_DEFAULT_VERSION_FIELD);
        map.put("TypeTestsStatus", TYPE_TESTS_STATUS_FIELD);
        map.put("TypeTestsStatusDescription", TYPE_TESTS_STATUS_DESCRIPTION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("ProvisioningType", PROVISIONING_TYPE_FIELD);
        map.put("DeprecatedStatus", DEPRECATED_STATUS_FIELD);
        map.put("LoggingConfig", LOGGING_CONFIG_FIELD);
        map.put("RequiredActivatedTypes", REQUIRED_ACTIVATED_TYPES_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("SourceUrl", SOURCE_URL_FIELD);
        map.put("DocumentationUrl", DOCUMENTATION_URL_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("TimeCreated", TIME_CREATED_FIELD);
        map.put("ConfigurationSchema", CONFIGURATION_SCHEMA_FIELD);
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
        map.put("OriginalTypeArn", ORIGINAL_TYPE_ARN_FIELD);
        map.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
        map.put("LatestPublicVersion", LATEST_PUBLIC_VERSION_FIELD);
        map.put("IsActivated", IS_ACTIVATED_FIELD);
        map.put("AutoUpdate", AUTO_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeResponse, T> g) {
        return obj -> g.apply((DescribeTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String typeName;
        private String defaultVersionId;
        private Boolean isDefaultVersion;
        private String typeTestsStatus;
        private String typeTestsStatusDescription;
        private String description;
        private String schema;
        private String provisioningType;
        private String deprecatedStatus;
        private LoggingConfig loggingConfig;
        private List<RequiredActivatedType> requiredActivatedTypes = DefaultSdkAutoConstructList.getInstance();
        private String executionRoleArn;
        private String visibility;
        private String sourceUrl;
        private String documentationUrl;
        private Instant lastUpdated;
        private Instant timeCreated;
        private String configurationSchema;
        private String publisherId;
        private String originalTypeName;
        private String originalTypeArn;
        private String publicVersionNumber;
        private String latestPublicVersion;
        private Boolean isActivated;
        private Boolean autoUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeResponse model) {
            super(model);
            this.arn(model.arn);
            this.type(model.type);
            this.typeName(model.typeName);
            this.defaultVersionId(model.defaultVersionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.typeTestsStatus(model.typeTestsStatus);
            this.typeTestsStatusDescription(model.typeTestsStatusDescription);
            this.description(model.description);
            this.schema(model.schema);
            this.provisioningType(model.provisioningType);
            this.deprecatedStatus(model.deprecatedStatus);
            this.loggingConfig(model.loggingConfig);
            this.requiredActivatedTypes(model.requiredActivatedTypes);
            this.executionRoleArn(model.executionRoleArn);
            this.visibility(model.visibility);
            this.sourceUrl(model.sourceUrl);
            this.documentationUrl(model.documentationUrl);
            this.lastUpdated(model.lastUpdated);
            this.timeCreated(model.timeCreated);
            this.configurationSchema(model.configurationSchema);
            this.publisherId(model.publisherId);
            this.originalTypeName(model.originalTypeName);
            this.originalTypeArn(model.originalTypeArn);
            this.publicVersionNumber(model.publicVersionNumber);
            this.latestPublicVersion(model.latestPublicVersion);
            this.isActivated(model.isActivated);
            this.autoUpdate(model.autoUpdate);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final String getTypeTestsStatus() {
            return this.typeTestsStatus;
        }

        public final void setTypeTestsStatus(String typeTestsStatus) {
            this.typeTestsStatus = typeTestsStatus;
        }

        @Override
        public final Builder typeTestsStatus(String typeTestsStatus) {
            this.typeTestsStatus = typeTestsStatus;
            return this;
        }

        @Override
        public final Builder typeTestsStatus(TypeTestsStatus typeTestsStatus) {
            this.typeTestsStatus(typeTestsStatus == null ? null : typeTestsStatus.toString());
            return this;
        }

        public final String getTypeTestsStatusDescription() {
            return this.typeTestsStatusDescription;
        }

        public final void setTypeTestsStatusDescription(String typeTestsStatusDescription) {
            this.typeTestsStatusDescription = typeTestsStatusDescription;
        }

        @Override
        public final Builder typeTestsStatusDescription(String typeTestsStatusDescription) {
            this.typeTestsStatusDescription = typeTestsStatusDescription;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getProvisioningType() {
            return this.provisioningType;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final String getDeprecatedStatus() {
            return this.deprecatedStatus;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final List<RequiredActivatedType.Builder> getRequiredActivatedTypes() {
            List<RequiredActivatedType.Builder> result = RequiredActivatedTypesCopier.copyToBuilder(this.requiredActivatedTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredActivatedTypes(Collection<RequiredActivatedType.BuilderImpl> requiredActivatedTypes) {
            this.requiredActivatedTypes = RequiredActivatedTypesCopier.copyFromBuilder(requiredActivatedTypes);
        }

        @Override
        public final Builder requiredActivatedTypes(Collection<RequiredActivatedType> requiredActivatedTypes) {
            this.requiredActivatedTypes = RequiredActivatedTypesCopier.copy(requiredActivatedTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredActivatedTypes(RequiredActivatedType ... requiredActivatedTypes) {
            this.requiredActivatedTypes(Arrays.asList(requiredActivatedTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredActivatedTypes(Consumer<RequiredActivatedType.Builder> ... requiredActivatedTypes) {
            this.requiredActivatedTypes(Stream.of(requiredActivatedTypes).map(c -> (RequiredActivatedType)((RequiredActivatedType.Builder)RequiredActivatedType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final String getDocumentationUrl() {
            return this.documentationUrl;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final Instant getTimeCreated() {
            return this.timeCreated;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final String getConfigurationSchema() {
            return this.configurationSchema;
        }

        public final void setConfigurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
        }

        @Override
        public final Builder configurationSchema(String configurationSchema) {
            this.configurationSchema = configurationSchema;
            return this;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getOriginalTypeName() {
            return this.originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getOriginalTypeArn() {
            return this.originalTypeArn;
        }

        public final void setOriginalTypeArn(String originalTypeArn) {
            this.originalTypeArn = originalTypeArn;
        }

        @Override
        public final Builder originalTypeArn(String originalTypeArn) {
            this.originalTypeArn = originalTypeArn;
            return this;
        }

        public final String getPublicVersionNumber() {
            return this.publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        public final String getLatestPublicVersion() {
            return this.latestPublicVersion;
        }

        public final void setLatestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
        }

        @Override
        public final Builder latestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
            return this;
        }

        public final Boolean getIsActivated() {
            return this.isActivated;
        }

        public final void setIsActivated(Boolean isActivated) {
            this.isActivated = isActivated;
        }

        @Override
        public final Builder isActivated(Boolean isActivated) {
            this.isActivated = isActivated;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        @Override
        public DescribeTypeResponse build() {
            return new DescribeTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTypeResponse> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder defaultVersionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder typeTestsStatus(String var1);

        public Builder typeTestsStatus(TypeTestsStatus var1);

        public Builder typeTestsStatusDescription(String var1);

        public Builder description(String var1);

        public Builder schema(String var1);

        public Builder provisioningType(String var1);

        public Builder provisioningType(ProvisioningType var1);

        public Builder deprecatedStatus(String var1);

        public Builder deprecatedStatus(DeprecatedStatus var1);

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder requiredActivatedTypes(Collection<RequiredActivatedType> var1);

        public Builder requiredActivatedTypes(RequiredActivatedType ... var1);

        public Builder requiredActivatedTypes(Consumer<RequiredActivatedType.Builder> ... var1);

        public Builder executionRoleArn(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder sourceUrl(String var1);

        public Builder documentationUrl(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder timeCreated(Instant var1);

        public Builder configurationSchema(String var1);

        public Builder publisherId(String var1);

        public Builder originalTypeName(String var1);

        public Builder originalTypeArn(String var1);

        public Builder publicVersionNumber(String var1);

        public Builder latestPublicVersion(String var1);

        public Builder isActivated(Boolean var1);

        public Builder autoUpdate(Boolean var1);
    }
}

