/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.OrganizationalUnitIdListCopier;
import software.amazon.awssdk.services.cloudformation.model.StackIdListCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportStacksToStackSetRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ImportStacksToStackSetRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::stackSetName)).setter(ImportStacksToStackSetRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<List<String>> STACK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackIds").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::stackIds)).setter(ImportStacksToStackSetRequest.setter(Builder::stackIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_IDS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackIdsUrl").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::stackIdsUrl)).setter(ImportStacksToStackSetRequest.setter(Builder::stackIdsUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIdsUrl").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitIds").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::organizationalUnitIds)).setter(ImportStacksToStackSetRequest.setter(Builder::organizationalUnitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationPreferences").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::operationPreferences)).setter(ImportStacksToStackSetRequest.setter(Builder::operationPreferences)).constructor(StackSetOperationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::operationId)).setter(ImportStacksToStackSetRequest.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(ImportStacksToStackSetRequest.getter(ImportStacksToStackSetRequest::callAsAsString)).setter(ImportStacksToStackSetRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, STACK_IDS_FIELD, STACK_IDS_URL_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, OPERATION_PREFERENCES_FIELD, OPERATION_ID_FIELD, CALL_AS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportStacksToStackSetRequest.memberNameToFieldInitializer();
    private final String stackSetName;
    private final List<String> stackIds;
    private final String stackIdsUrl;
    private final List<String> organizationalUnitIds;
    private final StackSetOperationPreferences operationPreferences;
    private final String operationId;
    private final String callAs;

    private ImportStacksToStackSetRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.stackIds = builder.stackIds;
        this.stackIdsUrl = builder.stackIdsUrl;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.operationPreferences = builder.operationPreferences;
        this.operationId = builder.operationId;
        this.callAs = builder.callAs;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final boolean hasStackIds() {
        return this.stackIds != null && !(this.stackIds instanceof SdkAutoConstructList);
    }

    public final List<String> stackIds() {
        return this.stackIds;
    }

    public final String stackIdsUrl() {
        return this.stackIdsUrl;
    }

    public final boolean hasOrganizationalUnitIds() {
        return this.organizationalUnitIds != null && !(this.organizationalUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitIds() {
        return this.organizationalUnitIds;
    }

    public final StackSetOperationPreferences operationPreferences() {
        return this.operationPreferences;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackIds() ? this.stackIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackIdsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportStacksToStackSetRequest)) {
            return false;
        }
        ImportStacksToStackSetRequest other = (ImportStacksToStackSetRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && this.hasStackIds() == other.hasStackIds() && Objects.equals(this.stackIds(), other.stackIds()) && Objects.equals(this.stackIdsUrl(), other.stackIdsUrl()) && this.hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds() && Objects.equals(this.organizationalUnitIds(), other.organizationalUnitIds()) && Objects.equals(this.operationPreferences(), other.operationPreferences()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.callAsAsString(), other.callAsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImportStacksToStackSetRequest").add("StackSetName", (Object)this.stackSetName()).add("StackIds", this.hasStackIds() ? this.stackIds() : null).add("StackIdsUrl", (Object)this.stackIdsUrl()).add("OrganizationalUnitIds", this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null).add("OperationPreferences", (Object)this.operationPreferences()).add("OperationId", (Object)this.operationId()).add("CallAs", (Object)this.callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "StackIds": {
                return Optional.ofNullable(clazz.cast(this.stackIds()));
            }
            case "StackIdsUrl": {
                return Optional.ofNullable(clazz.cast(this.stackIdsUrl()));
            }
            case "OrganizationalUnitIds": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitIds()));
            }
            case "OperationPreferences": {
                return Optional.ofNullable(clazz.cast(this.operationPreferences()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("StackIds", STACK_IDS_FIELD);
        map.put("StackIdsUrl", STACK_IDS_URL_FIELD);
        map.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
        map.put("OperationPreferences", OPERATION_PREFERENCES_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("CallAs", CALL_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportStacksToStackSetRequest, T> g) {
        return obj -> g.apply((ImportStacksToStackSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private List<String> stackIds = DefaultSdkAutoConstructList.getInstance();
        private String stackIdsUrl;
        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();
        private StackSetOperationPreferences operationPreferences;
        private String operationId;
        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportStacksToStackSetRequest model) {
            super(model);
            this.stackSetName(model.stackSetName);
            this.stackIds(model.stackIds);
            this.stackIdsUrl(model.stackIdsUrl);
            this.organizationalUnitIds(model.organizationalUnitIds);
            this.operationPreferences(model.operationPreferences);
            this.operationId(model.operationId);
            this.callAs(model.callAs);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final Collection<String> getStackIds() {
            if (this.stackIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackIds;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StackIdListCopier.copy(stackIds);
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StackIdListCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String ... stackIds) {
            this.stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final String getStackIdsUrl() {
            return this.stackIdsUrl;
        }

        public final void setStackIdsUrl(String stackIdsUrl) {
            this.stackIdsUrl = stackIdsUrl;
        }

        @Override
        public final Builder stackIdsUrl(String stackIdsUrl) {
            this.stackIdsUrl = stackIdsUrl;
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (this.organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String ... organizationalUnitIds) {
            this.organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return this.operationPreferences != null ? this.operationPreferences.toBuilder() : null;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportStacksToStackSetRequest build() {
            return new ImportStacksToStackSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportStacksToStackSetRequest> {
        public Builder stackSetName(String var1);

        public Builder stackIds(Collection<String> var1);

        public Builder stackIds(String ... var1);

        public Builder stackIdsUrl(String var1);

        public Builder organizationalUnitIds(Collection<String> var1);

        public Builder organizationalUnitIds(String ... var1);

        public Builder operationPreferences(StackSetOperationPreferences var1);

        default public Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return this.operationPreferences((StackSetOperationPreferences)((StackSetOperationPreferences.Builder)StackSetOperationPreferences.builder().applyMutation(operationPreferences)).build());
        }

        public Builder operationId(String var1);

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

