/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanSummary;

public class ListResourceScansPublisher
implements SdkPublisher<ListResourceScansResponse> {
    private final CloudFormationAsyncClient client;
    private final ListResourceScansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceScansPublisher(CloudFormationAsyncClient client, ListResourceScansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceScansPublisher(CloudFormationAsyncClient client, ListResourceScansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceScansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceScansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceScanSummary> resourceScanSummaries() {
        Function<ListResourceScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceScanSummaries() != null) {
                return response.resourceScanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceScansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceScansResponseFetcher
    implements AsyncPageFetcher<ListResourceScansResponse> {
        private ListResourceScansResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceScansResponse> nextPage(ListResourceScansResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScansPublisher.this.client.listResourceScans(ListResourceScansPublisher.this.firstRequest);
            }
            return ListResourceScansPublisher.this.client.listResourceScans((ListResourceScansRequest)((Object)ListResourceScansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

