/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyAction {
    DELETE("Delete"),
    RETAIN("Retain"),
    SNAPSHOT("Snapshot"),
    REPLACE_AND_DELETE("ReplaceAndDelete"),
    REPLACE_AND_RETAIN("ReplaceAndRetain"),
    REPLACE_AND_SNAPSHOT("ReplaceAndSnapshot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyAction> VALUE_MAP;
    private final String value;

    private PolicyAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyAction> knownValues() {
        EnumSet<PolicyAction> knownValues = EnumSet.allOf(PolicyAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyAction.class, PolicyAction::toString);
    }
}

