/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ScannedResource;

public class ListResourceScanResourcesPublisher
implements SdkPublisher<ListResourceScanResourcesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListResourceScanResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceScanResourcesPublisher(CloudFormationAsyncClient client, ListResourceScanResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceScanResourcesPublisher(CloudFormationAsyncClient client, ListResourceScanResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceScanResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceScanResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScannedResource> resources() {
        Function<ListResourceScanResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceScanResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceScanResourcesResponseFetcher
    implements AsyncPageFetcher<ListResourceScanResourcesResponse> {
        private ListResourceScanResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScanResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceScanResourcesResponse> nextPage(ListResourceScanResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScanResourcesPublisher.this.client.listResourceScanResources(ListResourceScanResourcesPublisher.this.firstRequest);
            }
            return ListResourceScanResourcesPublisher.this.client.listResourceScanResources((ListResourceScanResourcesRequest)((Object)ListResourceScanResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

