/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.IdentityProvider;
import software.amazon.awssdk.services.cloudformation.model.PublisherStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePublisherResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribePublisherResponse> {
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(DescribePublisherResponse.getter(DescribePublisherResponse::publisherId)).setter(DescribePublisherResponse.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<String> PUBLISHER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherStatus").getter(DescribePublisherResponse.getter(DescribePublisherResponse::publisherStatusAsString)).setter(DescribePublisherResponse.setter(Builder::publisherStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherStatus").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProvider").getter(DescribePublisherResponse.getter(DescribePublisherResponse::identityProviderAsString)).setter(DescribePublisherResponse.setter(Builder::identityProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final SdkField<String> PUBLISHER_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherProfile").getter(DescribePublisherResponse.getter(DescribePublisherResponse::publisherProfile)).setter(DescribePublisherResponse.setter(Builder::publisherProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherProfile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHER_ID_FIELD, PUBLISHER_STATUS_FIELD, IDENTITY_PROVIDER_FIELD, PUBLISHER_PROFILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePublisherResponse.memberNameToFieldInitializer();
    private final String publisherId;
    private final String publisherStatus;
    private final String identityProvider;
    private final String publisherProfile;

    private DescribePublisherResponse(BuilderImpl builder) {
        super(builder);
        this.publisherId = builder.publisherId;
        this.publisherStatus = builder.publisherStatus;
        this.identityProvider = builder.identityProvider;
        this.publisherProfile = builder.publisherProfile;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final PublisherStatus publisherStatus() {
        return PublisherStatus.fromValue(this.publisherStatus);
    }

    public final String publisherStatusAsString() {
        return this.publisherStatus;
    }

    public final IdentityProvider identityProvider() {
        return IdentityProvider.fromValue(this.identityProvider);
    }

    public final String identityProviderAsString() {
        return this.identityProvider;
    }

    public final String publisherProfile() {
        return this.publisherProfile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherProfile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublisherResponse)) {
            return false;
        }
        DescribePublisherResponse other = (DescribePublisherResponse)((Object)obj);
        return Objects.equals(this.publisherId(), other.publisherId()) && Objects.equals(this.publisherStatusAsString(), other.publisherStatusAsString()) && Objects.equals(this.identityProviderAsString(), other.identityProviderAsString()) && Objects.equals(this.publisherProfile(), other.publisherProfile());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePublisherResponse").add("PublisherId", (Object)this.publisherId()).add("PublisherStatus", (Object)this.publisherStatusAsString()).add("IdentityProvider", (Object)this.identityProviderAsString()).add("PublisherProfile", (Object)this.publisherProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "PublisherStatus": {
                return Optional.ofNullable(clazz.cast(this.publisherStatusAsString()));
            }
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProviderAsString()));
            }
            case "PublisherProfile": {
                return Optional.ofNullable(clazz.cast(this.publisherProfile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("PublisherStatus", PUBLISHER_STATUS_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("PublisherProfile", PUBLISHER_PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePublisherResponse, T> g) {
        return obj -> g.apply((DescribePublisherResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String publisherId;
        private String publisherStatus;
        private String identityProvider;
        private String publisherProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublisherResponse model) {
            super(model);
            this.publisherId(model.publisherId);
            this.publisherStatus(model.publisherStatus);
            this.identityProvider(model.identityProvider);
            this.publisherProfile(model.publisherProfile);
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getPublisherStatus() {
            return this.publisherStatus;
        }

        public final void setPublisherStatus(String publisherStatus) {
            this.publisherStatus = publisherStatus;
        }

        @Override
        public final Builder publisherStatus(String publisherStatus) {
            this.publisherStatus = publisherStatus;
            return this;
        }

        @Override
        public final Builder publisherStatus(PublisherStatus publisherStatus) {
            this.publisherStatus(publisherStatus == null ? null : publisherStatus.toString());
            return this;
        }

        public final String getIdentityProvider() {
            return this.identityProvider;
        }

        public final void setIdentityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
        }

        @Override
        public final Builder identityProvider(String identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider(identityProvider == null ? null : identityProvider.toString());
            return this;
        }

        public final String getPublisherProfile() {
            return this.publisherProfile;
        }

        public final void setPublisherProfile(String publisherProfile) {
            this.publisherProfile = publisherProfile;
        }

        @Override
        public final Builder publisherProfile(String publisherProfile) {
            this.publisherProfile = publisherProfile;
            return this;
        }

        @Override
        public DescribePublisherResponse build() {
            return new DescribePublisherResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePublisherResponse> {
        public Builder publisherId(String var1);

        public Builder publisherStatus(String var1);

        public Builder publisherStatus(PublisherStatus var1);

        public Builder identityProvider(String var1);

        public Builder identityProvider(IdentityProvider var1);

        public Builder publisherProfile(String var1);
    }
}

