/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.AttributeChangeType;
import software.amazon.awssdk.services.cloudformation.model.RequiresRecreation;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceTargetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceTargetDefinition> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::attributeAsString)).setter(ResourceTargetDefinition.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::name)).setter(ResourceTargetDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REQUIRES_RECREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequiresRecreation").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::requiresRecreationAsString)).setter(ResourceTargetDefinition.setter(Builder::requiresRecreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRecreation").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::path)).setter(ResourceTargetDefinition.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> BEFORE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BeforeValue").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::beforeValue)).setter(ResourceTargetDefinition.setter(Builder::beforeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeforeValue").build()}).build();
    private static final SdkField<String> AFTER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfterValue").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::afterValue)).setter(ResourceTargetDefinition.setter(Builder::afterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterValue").build()}).build();
    private static final SdkField<String> ATTRIBUTE_CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeChangeType").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::attributeChangeTypeAsString)).setter(ResourceTargetDefinition.setter(Builder::attributeChangeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeChangeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, NAME_FIELD, REQUIRES_RECREATION_FIELD, PATH_FIELD, BEFORE_VALUE_FIELD, AFTER_VALUE_FIELD, ATTRIBUTE_CHANGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Attribute", ATTRIBUTE_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RequiresRecreation", REQUIRES_RECREATION_FIELD);
            this.put("Path", PATH_FIELD);
            this.put("BeforeValue", BEFORE_VALUE_FIELD);
            this.put("AfterValue", AFTER_VALUE_FIELD);
            this.put("AttributeChangeType", ATTRIBUTE_CHANGE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String name;
    private final String requiresRecreation;
    private final String path;
    private final String beforeValue;
    private final String afterValue;
    private final String attributeChangeType;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
        this.path = builder.path;
        this.beforeValue = builder.beforeValue;
        this.afterValue = builder.afterValue;
        this.attributeChangeType = builder.attributeChangeType;
    }

    public final ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final String name() {
        return this.name;
    }

    public final RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(this.requiresRecreation);
    }

    public final String requiresRecreationAsString() {
        return this.requiresRecreation;
    }

    public final String path() {
        return this.path;
    }

    public final String beforeValue() {
        return this.beforeValue;
    }

    public final String afterValue() {
        return this.afterValue;
    }

    public final AttributeChangeType attributeChangeType() {
        return AttributeChangeType.fromValue(this.attributeChangeType);
    }

    public final String attributeChangeTypeAsString() {
        return this.attributeChangeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresRecreationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeChangeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requiresRecreationAsString(), other.requiresRecreationAsString()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.beforeValue(), other.beforeValue()) && Objects.equals(this.afterValue(), other.afterValue()) && Objects.equals(this.attributeChangeTypeAsString(), other.attributeChangeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceTargetDefinition").add("Attribute", (Object)this.attributeAsString()).add("Name", (Object)this.name()).add("RequiresRecreation", (Object)this.requiresRecreationAsString()).add("Path", (Object)this.path()).add("BeforeValue", (Object)this.beforeValue()).add("AfterValue", (Object)this.afterValue()).add("AttributeChangeType", (Object)this.attributeChangeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RequiresRecreation": {
                return Optional.ofNullable(clazz.cast(this.requiresRecreationAsString()));
            }
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "BeforeValue": {
                return Optional.ofNullable(clazz.cast(this.beforeValue()));
            }
            case "AfterValue": {
                return Optional.ofNullable(clazz.cast(this.afterValue()));
            }
            case "AttributeChangeType": {
                return Optional.ofNullable(clazz.cast(this.attributeChangeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceTargetDefinition, T> g) {
        return obj -> g.apply((ResourceTargetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String name;
        private String requiresRecreation;
        private String path;
        private String beforeValue;
        private String afterValue;
        private String attributeChangeType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            this.attribute(model.attribute);
            this.name(model.name);
            this.requiresRecreation(model.requiresRecreation);
            this.path(model.path);
            this.beforeValue(model.beforeValue);
            this.afterValue(model.afterValue);
            this.attributeChangeType(model.attributeChangeType);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequiresRecreation() {
            return this.requiresRecreation;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation == null ? null : requiresRecreation.toString());
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getBeforeValue() {
            return this.beforeValue;
        }

        public final void setBeforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
        }

        @Override
        public final Builder beforeValue(String beforeValue) {
            this.beforeValue = beforeValue;
            return this;
        }

        public final String getAfterValue() {
            return this.afterValue;
        }

        public final void setAfterValue(String afterValue) {
            this.afterValue = afterValue;
        }

        @Override
        public final Builder afterValue(String afterValue) {
            this.afterValue = afterValue;
            return this;
        }

        public final String getAttributeChangeType() {
            return this.attributeChangeType;
        }

        public final void setAttributeChangeType(String attributeChangeType) {
            this.attributeChangeType = attributeChangeType;
        }

        @Override
        public final Builder attributeChangeType(String attributeChangeType) {
            this.attributeChangeType = attributeChangeType;
            return this;
        }

        @Override
        public final Builder attributeChangeType(AttributeChangeType attributeChangeType) {
            this.attributeChangeType(attributeChangeType == null ? null : attributeChangeType.toString());
            return this;
        }

        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceTargetDefinition> {
        public Builder attribute(String var1);

        public Builder attribute(ResourceAttribute var1);

        public Builder name(String var1);

        public Builder requiresRecreation(String var1);

        public Builder requiresRecreation(RequiresRecreation var1);

        public Builder path(String var1);

        public Builder beforeValue(String var1);

        public Builder afterValue(String var1);

        public Builder attributeChangeType(String var1);

        public Builder attributeChangeType(AttributeChangeType var1);
    }
}

