/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.IdentityProvider;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypeSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TypeSummary.getter(TypeSummary::typeAsString)).setter(TypeSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(TypeSummary.getter(TypeSummary::typeName)).setter(TypeSummary.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultVersionId").getter(TypeSummary.getter(TypeSummary::defaultVersionId)).setter(TypeSummary.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(TypeSummary.getter(TypeSummary::typeArn)).setter(TypeSummary.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(TypeSummary.getter(TypeSummary::lastUpdated)).setter(TypeSummary.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TypeSummary.getter(TypeSummary::description)).setter(TypeSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(TypeSummary.getter(TypeSummary::publisherId)).setter(TypeSummary.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalTypeName").getter(TypeSummary.getter(TypeSummary::originalTypeName)).setter(TypeSummary.setter(Builder::originalTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()}).build();
    private static final SdkField<String> PUBLIC_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicVersionNumber").getter(TypeSummary.getter(TypeSummary::publicVersionNumber)).setter(TypeSummary.setter(Builder::publicVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicVersionNumber").build()}).build();
    private static final SdkField<String> LATEST_PUBLIC_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestPublicVersion").getter(TypeSummary.getter(TypeSummary::latestPublicVersion)).setter(TypeSummary.setter(Builder::latestPublicVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestPublicVersion").build()}).build();
    private static final SdkField<String> PUBLISHER_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherIdentity").getter(TypeSummary.getter(TypeSummary::publisherIdentityAsString)).setter(TypeSummary.setter(Builder::publisherIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherIdentity").build()}).build();
    private static final SdkField<String> PUBLISHER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherName").getter(TypeSummary.getter(TypeSummary::publisherName)).setter(TypeSummary.setter(Builder::publisherName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherName").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsActivated").getter(TypeSummary.getter(TypeSummary::isActivated)).setter(TypeSummary.setter(Builder::isActivated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsActivated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, TYPE_ARN_FIELD, LAST_UPDATED_FIELD, DESCRIPTION_FIELD, PUBLISHER_ID_FIELD, ORIGINAL_TYPE_NAME_FIELD, PUBLIC_VERSION_NUMBER_FIELD, LATEST_PUBLIC_VERSION_FIELD, PUBLISHER_IDENTITY_FIELD, PUBLISHER_NAME_FIELD, IS_ACTIVATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("DefaultVersionId", DEFAULT_VERSION_ID_FIELD);
            this.put("TypeArn", TYPE_ARN_FIELD);
            this.put("LastUpdated", LAST_UPDATED_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("PublisherId", PUBLISHER_ID_FIELD);
            this.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
            this.put("PublicVersionNumber", PUBLIC_VERSION_NUMBER_FIELD);
            this.put("LatestPublicVersion", LATEST_PUBLIC_VERSION_FIELD);
            this.put("PublisherIdentity", PUBLISHER_IDENTITY_FIELD);
            this.put("PublisherName", PUBLISHER_NAME_FIELD);
            this.put("IsActivated", IS_ACTIVATED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String typeName;
    private final String defaultVersionId;
    private final String typeArn;
    private final Instant lastUpdated;
    private final String description;
    private final String publisherId;
    private final String originalTypeName;
    private final String publicVersionNumber;
    private final String latestPublicVersion;
    private final String publisherIdentity;
    private final String publisherName;
    private final Boolean isActivated;

    private TypeSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.typeArn = builder.typeArn;
        this.lastUpdated = builder.lastUpdated;
        this.description = builder.description;
        this.publisherId = builder.publisherId;
        this.originalTypeName = builder.originalTypeName;
        this.publicVersionNumber = builder.publicVersionNumber;
        this.latestPublicVersion = builder.latestPublicVersion;
        this.publisherIdentity = builder.publisherIdentity;
        this.publisherName = builder.publisherName;
        this.isActivated = builder.isActivated;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String defaultVersionId() {
        return this.defaultVersionId;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String description() {
        return this.description;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final String originalTypeName() {
        return this.originalTypeName;
    }

    public final String publicVersionNumber() {
        return this.publicVersionNumber;
    }

    public final String latestPublicVersion() {
        return this.latestPublicVersion;
    }

    public final IdentityProvider publisherIdentity() {
        return IdentityProvider.fromValue(this.publisherIdentity);
    }

    public final String publisherIdentityAsString() {
        return this.publisherIdentity;
    }

    public final String publisherName() {
        return this.publisherName;
    }

    public final Boolean isActivated() {
        return this.isActivated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestPublicVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherIdentityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActivated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSummary)) {
            return false;
        }
        TypeSummary other = (TypeSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.publisherId(), other.publisherId()) && Objects.equals(this.originalTypeName(), other.originalTypeName()) && Objects.equals(this.publicVersionNumber(), other.publicVersionNumber()) && Objects.equals(this.latestPublicVersion(), other.latestPublicVersion()) && Objects.equals(this.publisherIdentityAsString(), other.publisherIdentityAsString()) && Objects.equals(this.publisherName(), other.publisherName()) && Objects.equals(this.isActivated(), other.isActivated());
    }

    public final String toString() {
        return ToString.builder((String)"TypeSummary").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("TypeArn", (Object)this.typeArn()).add("LastUpdated", (Object)this.lastUpdated()).add("Description", (Object)this.description()).add("PublisherId", (Object)this.publisherId()).add("OriginalTypeName", (Object)this.originalTypeName()).add("PublicVersionNumber", (Object)this.publicVersionNumber()).add("LatestPublicVersion", (Object)this.latestPublicVersion()).add("PublisherIdentity", (Object)this.publisherIdentityAsString()).add("PublisherName", (Object)this.publisherName()).add("IsActivated", (Object)this.isActivated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "OriginalTypeName": {
                return Optional.ofNullable(clazz.cast(this.originalTypeName()));
            }
            case "PublicVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.publicVersionNumber()));
            }
            case "LatestPublicVersion": {
                return Optional.ofNullable(clazz.cast(this.latestPublicVersion()));
            }
            case "PublisherIdentity": {
                return Optional.ofNullable(clazz.cast(this.publisherIdentityAsString()));
            }
            case "PublisherName": {
                return Optional.ofNullable(clazz.cast(this.publisherName()));
            }
            case "IsActivated": {
                return Optional.ofNullable(clazz.cast(this.isActivated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TypeSummary, T> g) {
        return obj -> g.apply((TypeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String defaultVersionId;
        private String typeArn;
        private Instant lastUpdated;
        private String description;
        private String publisherId;
        private String originalTypeName;
        private String publicVersionNumber;
        private String latestPublicVersion;
        private String publisherIdentity;
        private String publisherName;
        private Boolean isActivated;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeSummary model) {
            this.type(model.type);
            this.typeName(model.typeName);
            this.defaultVersionId(model.defaultVersionId);
            this.typeArn(model.typeArn);
            this.lastUpdated(model.lastUpdated);
            this.description(model.description);
            this.publisherId(model.publisherId);
            this.originalTypeName(model.originalTypeName);
            this.publicVersionNumber(model.publicVersionNumber);
            this.latestPublicVersion(model.latestPublicVersion);
            this.publisherIdentity(model.publisherIdentity);
            this.publisherName(model.publisherName);
            this.isActivated(model.isActivated);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getOriginalTypeName() {
            return this.originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getPublicVersionNumber() {
            return this.publicVersionNumber;
        }

        public final void setPublicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
        }

        @Override
        public final Builder publicVersionNumber(String publicVersionNumber) {
            this.publicVersionNumber = publicVersionNumber;
            return this;
        }

        public final String getLatestPublicVersion() {
            return this.latestPublicVersion;
        }

        public final void setLatestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
        }

        @Override
        public final Builder latestPublicVersion(String latestPublicVersion) {
            this.latestPublicVersion = latestPublicVersion;
            return this;
        }

        public final String getPublisherIdentity() {
            return this.publisherIdentity;
        }

        public final void setPublisherIdentity(String publisherIdentity) {
            this.publisherIdentity = publisherIdentity;
        }

        @Override
        public final Builder publisherIdentity(String publisherIdentity) {
            this.publisherIdentity = publisherIdentity;
            return this;
        }

        @Override
        public final Builder publisherIdentity(IdentityProvider publisherIdentity) {
            this.publisherIdentity(publisherIdentity == null ? null : publisherIdentity.toString());
            return this;
        }

        public final String getPublisherName() {
            return this.publisherName;
        }

        public final void setPublisherName(String publisherName) {
            this.publisherName = publisherName;
        }

        @Override
        public final Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            return this;
        }

        public final Boolean getIsActivated() {
            return this.isActivated;
        }

        public final void setIsActivated(Boolean isActivated) {
            this.isActivated = isActivated;
        }

        @Override
        public final Builder isActivated(Boolean isActivated) {
            this.isActivated = isActivated;
            return this;
        }

        public TypeSummary build() {
            return new TypeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypeSummary> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder defaultVersionId(String var1);

        public Builder typeArn(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder description(String var1);

        public Builder publisherId(String var1);

        public Builder originalTypeName(String var1);

        public Builder publicVersionNumber(String var1);

        public Builder latestPublicVersion(String var1);

        public Builder publisherIdentity(String var1);

        public Builder publisherIdentity(IdentityProvider var1);

        public Builder publisherName(String var1);

        public Builder isActivated(Boolean var1);
    }
}

