/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.HookFailureMode;
import software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint;
import software.amazon.awssdk.services.cloudformation.model.HookStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HookResultSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HookResultSummary> {
    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationPoint").getter(HookResultSummary.getter(HookResultSummary::invocationPointAsString)).setter(HookResultSummary.setter(Builder::invocationPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()}).build();
    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMode").getter(HookResultSummary.getter(HookResultSummary::failureModeAsString)).setter(HookResultSummary.setter(Builder::failureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(HookResultSummary.getter(HookResultSummary::typeName)).setter(HookResultSummary.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionId").getter(HookResultSummary.getter(HookResultSummary::typeVersionId)).setter(HookResultSummary.setter(Builder::typeVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()}).build();
    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeConfigurationVersionId").getter(HookResultSummary.getter(HookResultSummary::typeConfigurationVersionId)).setter(HookResultSummary.setter(Builder::typeConfigurationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(HookResultSummary.getter(HookResultSummary::statusAsString)).setter(HookResultSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatusReason").getter(HookResultSummary.getter(HookResultSummary::hookStatusReason)).setter(HookResultSummary.setter(Builder::hookStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_POINT_FIELD, FAILURE_MODE_FIELD, TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, TYPE_CONFIGURATION_VERSION_ID_FIELD, STATUS_FIELD, HOOK_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InvocationPoint", INVOCATION_POINT_FIELD);
            this.put("FailureMode", FAILURE_MODE_FIELD);
            this.put("TypeName", TYPE_NAME_FIELD);
            this.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
            this.put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String invocationPoint;
    private final String failureMode;
    private final String typeName;
    private final String typeVersionId;
    private final String typeConfigurationVersionId;
    private final String status;
    private final String hookStatusReason;

    private HookResultSummary(BuilderImpl builder) {
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.status = builder.status;
        this.hookStatusReason = builder.hookStatusReason;
    }

    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(this.invocationPoint);
    }

    public final String invocationPointAsString() {
        return this.invocationPoint;
    }

    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(this.failureMode);
    }

    public final String failureModeAsString() {
        return this.failureMode;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeVersionId() {
        return this.typeVersionId;
    }

    public final String typeConfigurationVersionId() {
        return this.typeConfigurationVersionId;
    }

    public final HookStatus status() {
        return HookStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String hookStatusReason() {
        return this.hookStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookResultSummary)) {
            return false;
        }
        HookResultSummary other = (HookResultSummary)obj;
        return Objects.equals(this.invocationPointAsString(), other.invocationPointAsString()) && Objects.equals(this.failureModeAsString(), other.failureModeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeVersionId(), other.typeVersionId()) && Objects.equals(this.typeConfigurationVersionId(), other.typeConfigurationVersionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.hookStatusReason(), other.hookStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"HookResultSummary").add("InvocationPoint", (Object)this.invocationPointAsString()).add("FailureMode", (Object)this.failureModeAsString()).add("TypeName", (Object)this.typeName()).add("TypeVersionId", (Object)this.typeVersionId()).add("TypeConfigurationVersionId", (Object)this.typeConfigurationVersionId()).add("Status", (Object)this.statusAsString()).add("HookStatusReason", (Object)this.hookStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvocationPoint": {
                return Optional.ofNullable(clazz.cast(this.invocationPointAsString()));
            }
            case "FailureMode": {
                return Optional.ofNullable(clazz.cast(this.failureModeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeVersionId()));
            }
            case "TypeConfigurationVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurationVersionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "HookStatusReason": {
                return Optional.ofNullable(clazz.cast(this.hookStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HookResultSummary, T> g) {
        return obj -> g.apply((HookResultSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String invocationPoint;
        private String failureMode;
        private String typeName;
        private String typeVersionId;
        private String typeConfigurationVersionId;
        private String status;
        private String hookStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(HookResultSummary model) {
            this.invocationPoint(model.invocationPoint);
            this.failureMode(model.failureMode);
            this.typeName(model.typeName);
            this.typeVersionId(model.typeVersionId);
            this.typeConfigurationVersionId(model.typeConfigurationVersionId);
            this.status(model.status);
            this.hookStatusReason(model.hookStatusReason);
        }

        public final String getInvocationPoint() {
            return this.invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return this.failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return this.typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return this.typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return this.hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public HookResultSummary build() {
            return new HookResultSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HookResultSummary> {
        public Builder invocationPoint(String var1);

        public Builder invocationPoint(HookInvocationPoint var1);

        public Builder failureMode(String var1);

        public Builder failureMode(HookFailureMode var1);

        public Builder typeName(String var1);

        public Builder typeVersionId(String var1);

        public Builder typeConfigurationVersionId(String var1);

        public Builder status(String var1);

        public Builder status(HookStatus var1);

        public Builder hookStatusReason(String var1);
    }
}

