/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Warnings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Warnings> {
    private static final SdkField<List<String>> UNRECOGNIZED_RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnrecognizedResourceTypes").getter(Warnings.getter(Warnings::unrecognizedResourceTypes)).setter(Warnings.setter(Builder::unrecognizedResourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnrecognizedResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNRECOGNIZED_RESOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UnrecognizedResourceTypes", UNRECOGNIZED_RESOURCE_TYPES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> unrecognizedResourceTypes;

    private Warnings(BuilderImpl builder) {
        this.unrecognizedResourceTypes = builder.unrecognizedResourceTypes;
    }

    public final boolean hasUnrecognizedResourceTypes() {
        return this.unrecognizedResourceTypes != null && !(this.unrecognizedResourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> unrecognizedResourceTypes() {
        return this.unrecognizedResourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnrecognizedResourceTypes() ? this.unrecognizedResourceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warnings)) {
            return false;
        }
        Warnings other = (Warnings)obj;
        return this.hasUnrecognizedResourceTypes() == other.hasUnrecognizedResourceTypes() && Objects.equals(this.unrecognizedResourceTypes(), other.unrecognizedResourceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"Warnings").add("UnrecognizedResourceTypes", this.hasUnrecognizedResourceTypes() ? this.unrecognizedResourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnrecognizedResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.unrecognizedResourceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Warnings, T> g) {
        return obj -> g.apply((Warnings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> unrecognizedResourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Warnings model) {
            this.unrecognizedResourceTypes(model.unrecognizedResourceTypes);
        }

        public final Collection<String> getUnrecognizedResourceTypes() {
            if (this.unrecognizedResourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unrecognizedResourceTypes;
        }

        public final void setUnrecognizedResourceTypes(Collection<String> unrecognizedResourceTypes) {
            this.unrecognizedResourceTypes = ResourceTypesCopier.copy(unrecognizedResourceTypes);
        }

        @Override
        public final Builder unrecognizedResourceTypes(Collection<String> unrecognizedResourceTypes) {
            this.unrecognizedResourceTypes = ResourceTypesCopier.copy(unrecognizedResourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unrecognizedResourceTypes(String ... unrecognizedResourceTypes) {
            this.unrecognizedResourceTypes(Arrays.asList(unrecognizedResourceTypes));
            return this;
        }

        public Warnings build() {
            return new Warnings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Warnings> {
        public Builder unrecognizedResourceTypes(Collection<String> var1);

        public Builder unrecognizedResourceTypes(String ... var1);
    }
}

