/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeTypeRegistrationResponse;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationAsyncWaiter;
import software.amazon.awssdk.services.cloudformation.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultCloudFormationAsyncWaiter
implements CloudFormationAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final CloudFormationAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeStacksResponse> stackExistsWaiter;
    private final AsyncWaiter<DescribeStacksResponse> stackCreateCompleteWaiter;
    private final AsyncWaiter<DescribeStacksResponse> stackDeleteCompleteWaiter;
    private final AsyncWaiter<DescribeStacksResponse> stackUpdateCompleteWaiter;
    private final AsyncWaiter<DescribeStacksResponse> stackImportCompleteWaiter;
    private final AsyncWaiter<DescribeStacksResponse> stackRollbackCompleteWaiter;
    private final AsyncWaiter<DescribeChangeSetResponse> changeSetCreateCompleteWaiter;
    private final AsyncWaiter<DescribeTypeRegistrationResponse> typeRegistrationCompleteWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultCloudFormationAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CloudFormationAsyncClient)CloudFormationAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.stackExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackExistsWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stackCreateCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackCreateCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stackDeleteCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackDeleteCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackDeleteCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stackUpdateCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackUpdateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackUpdateCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stackImportCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackImportCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackImportCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.stackRollbackCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeStacksResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.stackRollbackCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.stackRollbackCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.changeSetCreateCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChangeSetResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.changeSetCreateCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.changeSetCreateCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.typeRegistrationCompleteWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTypeRegistrationResponse.class).acceptors(DefaultCloudFormationAsyncWaiter.typeRegistrationCompleteWaiterAcceptors())).overrideConfiguration(DefaultCloudFormationAsyncWaiter.typeRegistrationCompleteWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChangeSetResponse>> waitUntilChangeSetCreateComplete(DescribeChangeSetRequest describeChangeSetRequest) {
        return this.changeSetCreateCompleteWaiter.runAsync(() -> this.client.describeChangeSet(this.applyWaitersUserAgent(describeChangeSetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChangeSetResponse>> waitUntilChangeSetCreateComplete(DescribeChangeSetRequest describeChangeSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.changeSetCreateCompleteWaiter.runAsync(() -> this.client.describeChangeSet(this.applyWaitersUserAgent(describeChangeSetRequest)), DefaultCloudFormationAsyncWaiter.changeSetCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackCreateCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackCreateComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackCreateCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackCreateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackDeleteCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackDeleteComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackDeleteCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackDeleteCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackExists(DescribeStacksRequest describeStacksRequest) {
        return this.stackExistsWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackExists(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackExistsWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackImportCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackImportComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackImportCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackImportCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackRollbackCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackRollbackComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackRollbackCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackRollbackCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest) {
        return this.stackUpdateCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeStacksResponse>> waitUntilStackUpdateComplete(DescribeStacksRequest describeStacksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stackUpdateCompleteWaiter.runAsync(() -> this.client.describeStacks(this.applyWaitersUserAgent(describeStacksRequest)), DefaultCloudFormationAsyncWaiter.stackUpdateCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTypeRegistrationResponse>> waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest describeTypeRegistrationRequest) {
        return this.typeRegistrationCompleteWaiter.runAsync(() -> this.client.describeTypeRegistration(this.applyWaitersUserAgent(describeTypeRegistrationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTypeRegistrationResponse>> waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest describeTypeRegistrationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.typeRegistrationCompleteWaiter.runAsync(() -> this.client.describeTypeRegistration(this.applyWaitersUserAgent(describeTypeRegistrationRequest)), DefaultCloudFormationAsyncWaiter.typeRegistrationCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "CREATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "CREATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackDeleteCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "DELETE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "CREATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_IN_PROGRESS"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_IN_PROGRESS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_COMPLETE) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackUpdateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackImportCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "IMPORT_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_IN_PROGRESS"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_IN_PROGRESS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "IMPORT_ROLLBACK_COMPLETE"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=IMPORT_ROLLBACK_COMPLETE) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStacksResponse>> stackRollbackCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStacksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStacksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_COMPLETE"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UPDATE_ROLLBACK_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=UPDATE_ROLLBACK_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Stacks").flatten().field("StackStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "DELETE_FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Stacks[].StackStatus=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChangeSetResponse>> changeSetCreateCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChangeSetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChangeSetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultCloudFormationAsyncWaiter.errorCode(error), "ValidationError"), (String)"A waiter acceptor was matched on error condition (ValidationError) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTypeRegistrationResponse>> typeRegistrationCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTypeRegistrationResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTypeRegistrationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressStatus").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ProgressStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ProgressStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration stackExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackDeleteCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackUpdateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackImportCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stackRollbackCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration changeSetCreateCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration typeRegistrationCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CloudFormationAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CloudFormationRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFormationRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CloudFormationAsyncWaiter.Builder {
        private CloudFormationAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public CloudFormationAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public CloudFormationAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CloudFormationAsyncWaiter.Builder client(CloudFormationAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CloudFormationAsyncWaiter build() {
            return new DefaultCloudFormationAsyncWaiter(this);
        }
    }
}

