/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ThirdPartyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestTypeRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, TestTypeRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TestTypeRequest.getter(TestTypeRequest::arn)).setter(TestTypeRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TestTypeRequest.getter(TestTypeRequest::typeAsString)).setter(TestTypeRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(TestTypeRequest.getter(TestTypeRequest::typeName)).setter(TestTypeRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(TestTypeRequest.getter(TestTypeRequest::versionId)).setter(TestTypeRequest.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> LOG_DELIVERY_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDeliveryBucket").getter(TestTypeRequest.getter(TestTypeRequest::logDeliveryBucket)).setter(TestTypeRequest.setter(Builder::logDeliveryBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryBucket").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, TYPE_NAME_FIELD, VERSION_ID_FIELD, LOG_DELIVERY_BUCKET_FIELD));
    private final String arn;
    private final String type;
    private final String typeName;
    private final String versionId;
    private final String logDeliveryBucket;

    private TestTypeRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.versionId = builder.versionId;
        this.logDeliveryBucket = builder.logDeliveryBucket;
    }

    public final String arn() {
        return this.arn;
    }

    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final String logDeliveryBucket() {
        return this.logDeliveryBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryBucket());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTypeRequest)) {
            return false;
        }
        TestTypeRequest other = (TestTypeRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.logDeliveryBucket(), other.logDeliveryBucket());
    }

    public final String toString() {
        return ToString.builder((String)"TestTypeRequest").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("VersionId", (Object)this.versionId()).add("LogDeliveryBucket", (Object)this.logDeliveryBucket()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "LogDeliveryBucket": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryBucket()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestTypeRequest, T> g) {
        return obj -> g.apply((TestTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String typeName;
        private String versionId;
        private String logDeliveryBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(TestTypeRequest model) {
            super(model);
            this.arn(model.arn);
            this.type(model.type);
            this.typeName(model.typeName);
            this.versionId(model.versionId);
            this.logDeliveryBucket(model.logDeliveryBucket);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getLogDeliveryBucket() {
            return this.logDeliveryBucket;
        }

        public final void setLogDeliveryBucket(String logDeliveryBucket) {
            this.logDeliveryBucket = logDeliveryBucket;
        }

        @Override
        public final Builder logDeliveryBucket(String logDeliveryBucket) {
            this.logDeliveryBucket = logDeliveryBucket;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestTypeRequest build() {
            return new TestTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestTypeRequest> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(ThirdPartyType var1);

        public Builder typeName(String var1);

        public Builder versionId(String var1);

        public Builder logDeliveryBucket(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

