/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScansResponse;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanSummary;

public class ListResourceScansIterable
implements SdkIterable<ListResourceScansResponse> {
    private final CloudFormationClient client;
    private final ListResourceScansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceScansIterable(CloudFormationClient client, ListResourceScansRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceScansResponseFetcher();
    }

    public Iterator<ListResourceScansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceScanSummary> resourceScanSummaries() {
        Function<ListResourceScansResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceScanSummaries() != null) {
                return response.resourceScanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceScansResponseFetcher
    implements SyncPageFetcher<ListResourceScansResponse> {
        private ListResourceScansResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceScansResponse nextPage(ListResourceScansResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScansIterable.this.client.listResourceScans(ListResourceScansIterable.this.firstRequest);
            }
            return ListResourceScansIterable.this.client.listResourceScans((ListResourceScansRequest)((Object)ListResourceScansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

