/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public class DescribeStackEventsIterable
implements SdkIterable<DescribeStackEventsResponse> {
    private final CloudFormationClient client;
    private final DescribeStackEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStackEventsIterable(CloudFormationClient client, DescribeStackEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeStackEventsResponseFetcher();
    }

    public Iterator<DescribeStackEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackEvent> stackEvents() {
        Function<DescribeStackEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.stackEvents() != null) {
                return response.stackEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeStackEventsResponseFetcher
    implements SyncPageFetcher<DescribeStackEventsResponse> {
        private DescribeStackEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStackEventsResponse nextPage(DescribeStackEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackEventsIterable.this.client.describeStackEvents(DescribeStackEventsIterable.this.firstRequest);
            }
            return DescribeStackEventsIterable.this.client.describeStackEvents((DescribeStackEventsRequest)((Object)DescribeStackEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

