/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackSetOperationAction {
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    DETECT_DRIFT("DETECT_DRIFT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackSetOperationAction> VALUE_MAP;
    private final String value;

    private StackSetOperationAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackSetOperationAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackSetOperationAction> knownValues() {
        EnumSet<StackSetOperationAction> knownValues = EnumSet.allOf(StackSetOperationAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackSetOperationAction.class, StackSetOperationAction::toString);
    }
}

