/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;

public class ListTypeRegistrationsPublisher
implements SdkPublisher<ListTypeRegistrationsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListTypeRegistrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypeRegistrationsPublisher(CloudFormationAsyncClient client, ListTypeRegistrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypeRegistrationsPublisher(CloudFormationAsyncClient client, ListTypeRegistrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypeRegistrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypeRegistrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTypeRegistrationsResponseFetcher
    implements AsyncPageFetcher<ListTypeRegistrationsResponse> {
        private ListTypeRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTypeRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTypeRegistrationsResponse> nextPage(ListTypeRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListTypeRegistrationsPublisher.this.client.listTypeRegistrations(ListTypeRegistrationsPublisher.this.firstRequest);
            }
            return ListTypeRegistrationsPublisher.this.client.listTypeRegistrations((ListTypeRegistrationsRequest)((Object)ListTypeRegistrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

