/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.AutoDeployment;
import software.amazon.awssdk.services.cloudformation.model.ManagedExecution;
import software.amazon.awssdk.services.cloudformation.model.PermissionModels;
import software.amazon.awssdk.services.cloudformation.model.StackDriftStatus;
import software.amazon.awssdk.services.cloudformation.model.StackSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetSummary> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(StackSetSummary.getter(StackSetSummary::stackSetName)).setter(StackSetSummary.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetId").getter(StackSetSummary.getter(StackSetSummary::stackSetId)).setter(StackSetSummary.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StackSetSummary.getter(StackSetSummary::description)).setter(StackSetSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StackSetSummary.getter(StackSetSummary::statusAsString)).setter(StackSetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<AutoDeployment> AUTO_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoDeployment").getter(StackSetSummary.getter(StackSetSummary::autoDeployment)).setter(StackSetSummary.setter(Builder::autoDeployment)).constructor(AutoDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeployment").build()}).build();
    private static final SdkField<String> PERMISSION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionModel").getter(StackSetSummary.getter(StackSetSummary::permissionModelAsString)).setter(StackSetSummary.setter(Builder::permissionModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionModel").build()}).build();
    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DriftStatus").getter(StackSetSummary.getter(StackSetSummary::driftStatusAsString)).setter(StackSetSummary.setter(Builder::driftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftStatus").build()}).build();
    private static final SdkField<Instant> LAST_DRIFT_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastDriftCheckTimestamp").getter(StackSetSummary.getter(StackSetSummary::lastDriftCheckTimestamp)).setter(StackSetSummary.setter(Builder::lastDriftCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDriftCheckTimestamp").build()}).build();
    private static final SdkField<ManagedExecution> MANAGED_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedExecution").getter(StackSetSummary.getter(StackSetSummary::managedExecution)).setter(StackSetSummary.setter(Builder::managedExecution)).constructor(ManagedExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedExecution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, STACK_SET_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, AUTO_DEPLOYMENT_FIELD, PERMISSION_MODEL_FIELD, DRIFT_STATUS_FIELD, LAST_DRIFT_CHECK_TIMESTAMP_FIELD, MANAGED_EXECUTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackSetName;
    private final String stackSetId;
    private final String description;
    private final String status;
    private final AutoDeployment autoDeployment;
    private final String permissionModel;
    private final String driftStatus;
    private final Instant lastDriftCheckTimestamp;
    private final ManagedExecution managedExecution;

    private StackSetSummary(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.stackSetId = builder.stackSetId;
        this.description = builder.description;
        this.status = builder.status;
        this.autoDeployment = builder.autoDeployment;
        this.permissionModel = builder.permissionModel;
        this.driftStatus = builder.driftStatus;
        this.lastDriftCheckTimestamp = builder.lastDriftCheckTimestamp;
        this.managedExecution = builder.managedExecution;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final String stackSetId() {
        return this.stackSetId;
    }

    public final String description() {
        return this.description;
    }

    public final StackSetStatus status() {
        return StackSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AutoDeployment autoDeployment() {
        return this.autoDeployment;
    }

    public final PermissionModels permissionModel() {
        return PermissionModels.fromValue(this.permissionModel);
    }

    public final String permissionModelAsString() {
        return this.permissionModel;
    }

    public final StackDriftStatus driftStatus() {
        return StackDriftStatus.fromValue(this.driftStatus);
    }

    public final String driftStatusAsString() {
        return this.driftStatus;
    }

    public final Instant lastDriftCheckTimestamp() {
        return this.lastDriftCheckTimestamp;
    }

    public final ManagedExecution managedExecution() {
        return this.managedExecution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDriftCheckTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedExecution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetSummary)) {
            return false;
        }
        StackSetSummary other = (StackSetSummary)obj;
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.autoDeployment(), other.autoDeployment()) && Objects.equals(this.permissionModelAsString(), other.permissionModelAsString()) && Objects.equals(this.driftStatusAsString(), other.driftStatusAsString()) && Objects.equals(this.lastDriftCheckTimestamp(), other.lastDriftCheckTimestamp()) && Objects.equals(this.managedExecution(), other.managedExecution());
    }

    public final String toString() {
        return ToString.builder((String)"StackSetSummary").add("StackSetName", (Object)this.stackSetName()).add("StackSetId", (Object)this.stackSetId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("AutoDeployment", (Object)this.autoDeployment()).add("PermissionModel", (Object)this.permissionModelAsString()).add("DriftStatus", (Object)this.driftStatusAsString()).add("LastDriftCheckTimestamp", (Object)this.lastDriftCheckTimestamp()).add("ManagedExecution", (Object)this.managedExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AutoDeployment": {
                return Optional.ofNullable(clazz.cast(this.autoDeployment()));
            }
            case "PermissionModel": {
                return Optional.ofNullable(clazz.cast(this.permissionModelAsString()));
            }
            case "DriftStatus": {
                return Optional.ofNullable(clazz.cast(this.driftStatusAsString()));
            }
            case "LastDriftCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastDriftCheckTimestamp()));
            }
            case "ManagedExecution": {
                return Optional.ofNullable(clazz.cast(this.managedExecution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetSummary, T> g) {
        return obj -> g.apply((StackSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String stackSetId;
        private String description;
        private String status;
        private AutoDeployment autoDeployment;
        private String permissionModel;
        private String driftStatus;
        private Instant lastDriftCheckTimestamp;
        private ManagedExecution managedExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetSummary model) {
            this.stackSetName(model.stackSetName);
            this.stackSetId(model.stackSetId);
            this.description(model.description);
            this.status(model.status);
            this.autoDeployment(model.autoDeployment);
            this.permissionModel(model.permissionModel);
            this.driftStatus(model.driftStatus);
            this.lastDriftCheckTimestamp(model.lastDriftCheckTimestamp);
            this.managedExecution(model.managedExecution);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AutoDeployment.Builder getAutoDeployment() {
            return this.autoDeployment != null ? this.autoDeployment.toBuilder() : null;
        }

        public final void setAutoDeployment(AutoDeployment.BuilderImpl autoDeployment) {
            this.autoDeployment = autoDeployment != null ? autoDeployment.build() : null;
        }

        @Override
        public final Builder autoDeployment(AutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        public final String getPermissionModel() {
            return this.permissionModel;
        }

        public final void setPermissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
        }

        @Override
        public final Builder permissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        @Override
        public final Builder permissionModel(PermissionModels permissionModel) {
            this.permissionModel(permissionModel == null ? null : permissionModel.toString());
            return this;
        }

        public final String getDriftStatus() {
            return this.driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(StackDriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getLastDriftCheckTimestamp() {
            return this.lastDriftCheckTimestamp;
        }

        public final void setLastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
        }

        @Override
        public final Builder lastDriftCheckTimestamp(Instant lastDriftCheckTimestamp) {
            this.lastDriftCheckTimestamp = lastDriftCheckTimestamp;
            return this;
        }

        public final ManagedExecution.Builder getManagedExecution() {
            return this.managedExecution != null ? this.managedExecution.toBuilder() : null;
        }

        public final void setManagedExecution(ManagedExecution.BuilderImpl managedExecution) {
            this.managedExecution = managedExecution != null ? managedExecution.build() : null;
        }

        @Override
        public final Builder managedExecution(ManagedExecution managedExecution) {
            this.managedExecution = managedExecution;
            return this;
        }

        public StackSetSummary build() {
            return new StackSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetSummary> {
        public Builder stackSetName(String var1);

        public Builder stackSetId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(StackSetStatus var1);

        public Builder autoDeployment(AutoDeployment var1);

        default public Builder autoDeployment(Consumer<AutoDeployment.Builder> autoDeployment) {
            return this.autoDeployment((AutoDeployment)((AutoDeployment.Builder)AutoDeployment.builder().applyMutation(autoDeployment)).build());
        }

        public Builder permissionModel(String var1);

        public Builder permissionModel(PermissionModels var1);

        public Builder driftStatus(String var1);

        public Builder driftStatus(StackDriftStatus var1);

        public Builder lastDriftCheckTimestamp(Instant var1);

        public Builder managedExecution(ManagedExecution var1);

        default public Builder managedExecution(Consumer<ManagedExecution.Builder> managedExecution) {
            return this.managedExecution((ManagedExecution)((ManagedExecution.Builder)ManagedExecution.builder().applyMutation(managedExecution)).build());
        }
    }
}

