/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterKey").getter(TemplateParameter.getter(TemplateParameter::parameterKey)).setter(TemplateParameter.setter(Builder::parameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(TemplateParameter.getter(TemplateParameter::defaultValue)).setter(TemplateParameter.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NoEcho").getter(TemplateParameter.getter(TemplateParameter::noEcho)).setter(TemplateParameter.setter(Builder::noEcho)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoEcho").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TemplateParameter.getter(TemplateParameter::description)).setter(TemplateParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD, DEFAULT_VALUE_FIELD, NO_ECHO_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterKey;
    private final String defaultValue;
    private final Boolean noEcho;
    private final String description;

    private TemplateParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.defaultValue = builder.defaultValue;
        this.noEcho = builder.noEcho;
        this.description = builder.description;
    }

    public final String parameterKey() {
        return this.parameterKey;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final Boolean noEcho() {
        return this.noEcho;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateParameter)) {
            return false;
        }
        TemplateParameter other = (TemplateParameter)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.noEcho(), other.noEcho()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateParameter").add("ParameterKey", (Object)this.parameterKey()).add("DefaultValue", (Object)this.defaultValue()).add("NoEcho", (Object)this.noEcho()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.ofNullable(clazz.cast(this.parameterKey()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "NoEcho": {
                return Optional.ofNullable(clazz.cast(this.noEcho()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateParameter, T> g) {
        return obj -> g.apply((TemplateParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String defaultValue;
        private Boolean noEcho;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateParameter model) {
            this.parameterKey(model.parameterKey);
            this.defaultValue(model.defaultValue);
            this.noEcho(model.noEcho);
            this.description(model.description);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getNoEcho() {
            return this.noEcho;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public TemplateParameter build() {
            return new TemplateParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateParameter> {
        public Builder parameterKey(String var1);

        public Builder defaultValue(String var1);

        public Builder noEcho(Boolean var1);

        public Builder description(String var1);
    }
}

