/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.DeploymentTargets;
import software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSetOperation> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(StackSetOperation.getter(StackSetOperation::operationId)).setter(StackSetOperation.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetId").getter(StackSetOperation.getter(StackSetOperation::stackSetId)).setter(StackSetOperation.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(StackSetOperation.getter(StackSetOperation::actionAsString)).setter(StackSetOperation.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StackSetOperation.getter(StackSetOperation::statusAsString)).setter(StackSetOperation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationPreferences").getter(StackSetOperation.getter(StackSetOperation::operationPreferences)).setter(StackSetOperation.setter(Builder::operationPreferences)).constructor(StackSetOperationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build()}).build();
    private static final SdkField<Boolean> RETAIN_STACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RetainStacks").getter(StackSetOperation.getter(StackSetOperation::retainStacks)).setter(StackSetOperation.setter(Builder::retainStacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainStacks").build()}).build();
    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministrationRoleARN").getter(StackSetOperation.getter(StackSetOperation::administrationRoleARN)).setter(StackSetOperation.setter(Builder::administrationRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleName").getter(StackSetOperation.getter(StackSetOperation::executionRoleName)).setter(StackSetOperation.setter(Builder::executionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(StackSetOperation.getter(StackSetOperation::creationTimestamp)).setter(StackSetOperation.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(StackSetOperation.getter(StackSetOperation::endTimestamp)).setter(StackSetOperation.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<DeploymentTargets> DEPLOYMENT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentTargets").getter(StackSetOperation.getter(StackSetOperation::deploymentTargets)).setter(StackSetOperation.setter(Builder::deploymentTargets)).constructor(DeploymentTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentTargets").build()}).build();
    private static final SdkField<StackSetDriftDetectionDetails> STACK_SET_DRIFT_DETECTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackSetDriftDetectionDetails").getter(StackSetOperation.getter(StackSetOperation::stackSetDriftDetectionDetails)).setter(StackSetOperation.setter(Builder::stackSetDriftDetectionDetails)).constructor(StackSetDriftDetectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetDriftDetectionDetails").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(StackSetOperation.getter(StackSetOperation::statusReason)).setter(StackSetOperation.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD, STACK_SET_ID_FIELD, ACTION_FIELD, STATUS_FIELD, OPERATION_PREFERENCES_FIELD, RETAIN_STACKS_FIELD, ADMINISTRATION_ROLE_ARN_FIELD, EXECUTION_ROLE_NAME_FIELD, CREATION_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, DEPLOYMENT_TARGETS_FIELD, STACK_SET_DRIFT_DETECTION_DETAILS_FIELD, STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String operationId;
    private final String stackSetId;
    private final String action;
    private final String status;
    private final StackSetOperationPreferences operationPreferences;
    private final Boolean retainStacks;
    private final String administrationRoleARN;
    private final String executionRoleName;
    private final Instant creationTimestamp;
    private final Instant endTimestamp;
    private final DeploymentTargets deploymentTargets;
    private final StackSetDriftDetectionDetails stackSetDriftDetectionDetails;
    private final String statusReason;

    private StackSetOperation(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.stackSetId = builder.stackSetId;
        this.action = builder.action;
        this.status = builder.status;
        this.operationPreferences = builder.operationPreferences;
        this.retainStacks = builder.retainStacks;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
        this.creationTimestamp = builder.creationTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.deploymentTargets = builder.deploymentTargets;
        this.stackSetDriftDetectionDetails = builder.stackSetDriftDetectionDetails;
        this.statusReason = builder.statusReason;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final String stackSetId() {
        return this.stackSetId;
    }

    public final StackSetOperationAction action() {
        return StackSetOperationAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final StackSetOperationStatus status() {
        return StackSetOperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final StackSetOperationPreferences operationPreferences() {
        return this.operationPreferences;
    }

    public final Boolean retainStacks() {
        return this.retainStacks;
    }

    public final String administrationRoleARN() {
        return this.administrationRoleARN;
    }

    public final String executionRoleName() {
        return this.executionRoleName;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final DeploymentTargets deploymentTargets() {
        return this.deploymentTargets;
    }

    public final StackSetDriftDetectionDetails stackSetDriftDetectionDetails() {
        return this.stackSetDriftDetectionDetails;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetDriftDetectionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperation)) {
            return false;
        }
        StackSetOperation other = (StackSetOperation)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.operationPreferences(), other.operationPreferences()) && Objects.equals(this.retainStacks(), other.retainStacks()) && Objects.equals(this.administrationRoleARN(), other.administrationRoleARN()) && Objects.equals(this.executionRoleName(), other.executionRoleName()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.deploymentTargets(), other.deploymentTargets()) && Objects.equals(this.stackSetDriftDetectionDetails(), other.stackSetDriftDetectionDetails()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"StackSetOperation").add("OperationId", (Object)this.operationId()).add("StackSetId", (Object)this.stackSetId()).add("Action", (Object)this.actionAsString()).add("Status", (Object)this.statusAsString()).add("OperationPreferences", (Object)this.operationPreferences()).add("RetainStacks", (Object)this.retainStacks()).add("AdministrationRoleARN", (Object)this.administrationRoleARN()).add("ExecutionRoleName", (Object)this.executionRoleName()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("DeploymentTargets", (Object)this.deploymentTargets()).add("StackSetDriftDetectionDetails", (Object)this.stackSetDriftDetectionDetails()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "OperationPreferences": {
                return Optional.ofNullable(clazz.cast(this.operationPreferences()));
            }
            case "RetainStacks": {
                return Optional.ofNullable(clazz.cast(this.retainStacks()));
            }
            case "AdministrationRoleARN": {
                return Optional.ofNullable(clazz.cast(this.administrationRoleARN()));
            }
            case "ExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.executionRoleName()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "DeploymentTargets": {
                return Optional.ofNullable(clazz.cast(this.deploymentTargets()));
            }
            case "StackSetDriftDetectionDetails": {
                return Optional.ofNullable(clazz.cast(this.stackSetDriftDetectionDetails()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperation, T> g) {
        return obj -> g.apply((StackSetOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String stackSetId;
        private String action;
        private String status;
        private StackSetOperationPreferences operationPreferences;
        private Boolean retainStacks;
        private String administrationRoleARN;
        private String executionRoleName;
        private Instant creationTimestamp;
        private Instant endTimestamp;
        private DeploymentTargets deploymentTargets;
        private StackSetDriftDetectionDetails stackSetDriftDetectionDetails;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperation model) {
            this.operationId(model.operationId);
            this.stackSetId(model.stackSetId);
            this.action(model.action);
            this.status(model.status);
            this.operationPreferences(model.operationPreferences);
            this.retainStacks(model.retainStacks);
            this.administrationRoleARN(model.administrationRoleARN);
            this.executionRoleName(model.executionRoleName);
            this.creationTimestamp(model.creationTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.deploymentTargets(model.deploymentTargets);
            this.stackSetDriftDetectionDetails(model.stackSetDriftDetectionDetails);
            this.statusReason(model.statusReason);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackSetOperationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return this.operationPreferences != null ? this.operationPreferences.toBuilder() : null;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final Boolean getRetainStacks() {
            return this.retainStacks;
        }

        public final void setRetainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
        }

        @Override
        public final Builder retainStacks(Boolean retainStacks) {
            this.retainStacks = retainStacks;
            return this;
        }

        public final String getAdministrationRoleARN() {
            return this.administrationRoleARN;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final String getExecutionRoleName() {
            return this.executionRoleName;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final DeploymentTargets.Builder getDeploymentTargets() {
            return this.deploymentTargets != null ? this.deploymentTargets.toBuilder() : null;
        }

        public final void setDeploymentTargets(DeploymentTargets.BuilderImpl deploymentTargets) {
            this.deploymentTargets = deploymentTargets != null ? deploymentTargets.build() : null;
        }

        @Override
        public final Builder deploymentTargets(DeploymentTargets deploymentTargets) {
            this.deploymentTargets = deploymentTargets;
            return this;
        }

        public final StackSetDriftDetectionDetails.Builder getStackSetDriftDetectionDetails() {
            return this.stackSetDriftDetectionDetails != null ? this.stackSetDriftDetectionDetails.toBuilder() : null;
        }

        public final void setStackSetDriftDetectionDetails(StackSetDriftDetectionDetails.BuilderImpl stackSetDriftDetectionDetails) {
            this.stackSetDriftDetectionDetails = stackSetDriftDetectionDetails != null ? stackSetDriftDetectionDetails.build() : null;
        }

        @Override
        public final Builder stackSetDriftDetectionDetails(StackSetDriftDetectionDetails stackSetDriftDetectionDetails) {
            this.stackSetDriftDetectionDetails = stackSetDriftDetectionDetails;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public StackSetOperation build() {
            return new StackSetOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSetOperation> {
        public Builder operationId(String var1);

        public Builder stackSetId(String var1);

        public Builder action(String var1);

        public Builder action(StackSetOperationAction var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationStatus var1);

        public Builder operationPreferences(StackSetOperationPreferences var1);

        default public Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return this.operationPreferences((StackSetOperationPreferences)((StackSetOperationPreferences.Builder)StackSetOperationPreferences.builder().applyMutation(operationPreferences)).build());
        }

        public Builder retainStacks(Boolean var1);

        public Builder administrationRoleARN(String var1);

        public Builder executionRoleName(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder deploymentTargets(DeploymentTargets var1);

        default public Builder deploymentTargets(Consumer<DeploymentTargets.Builder> deploymentTargets) {
            return this.deploymentTargets((DeploymentTargets)((DeploymentTargets.Builder)DeploymentTargets.builder().applyMutation(deploymentTargets)).build());
        }

        public Builder stackSetDriftDetectionDetails(StackSetDriftDetectionDetails var1);

        default public Builder stackSetDriftDetectionDetails(Consumer<StackSetDriftDetectionDetails.Builder> stackSetDriftDetectionDetails) {
            return this.stackSetDriftDetectionDetails((StackSetDriftDetectionDetails)((StackSetDriftDetectionDetails.Builder)StackSetDriftDetectionDetails.builder().applyMutation(stackSetDriftDetectionDetails)).build());
        }

        public Builder statusReason(String var1);
    }
}

