/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.RequiresRecreation;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceTargetDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceTargetDefinition> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::attributeAsString)).setter(ResourceTargetDefinition.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::name)).setter(ResourceTargetDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REQUIRES_RECREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequiresRecreation").getter(ResourceTargetDefinition.getter(ResourceTargetDefinition::requiresRecreationAsString)).setter(ResourceTargetDefinition.setter(Builder::requiresRecreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiresRecreation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, NAME_FIELD, REQUIRES_RECREATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String name;
    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    public final ResourceAttribute attribute() {
        return ResourceAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final String name() {
        return this.name;
    }

    public final RequiresRecreation requiresRecreation() {
        return RequiresRecreation.fromValue(this.requiresRecreation);
    }

    public final String requiresRecreationAsString() {
        return this.requiresRecreation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiresRecreationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requiresRecreationAsString(), other.requiresRecreationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceTargetDefinition").add("Attribute", (Object)this.attributeAsString()).add("Name", (Object)this.name()).add("RequiresRecreation", (Object)this.requiresRecreationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RequiresRecreation": {
                return Optional.ofNullable(clazz.cast(this.requiresRecreationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceTargetDefinition, T> g) {
        return obj -> g.apply((ResourceTargetDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String name;
        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            this.attribute(model.attribute);
            this.name(model.name);
            this.requiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequiresRecreation() {
            return this.requiresRecreation;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation == null ? null : requiresRecreation.toString());
            return this;
        }

        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceTargetDefinition> {
        public Builder attribute(String var1);

        public Builder attribute(ResourceAttribute var1);

        public Builder name(String var1);

        public Builder requiresRecreation(String var1);

        public Builder requiresRecreation(RequiresRecreation var1);
    }
}

