/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackInstancesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary;

public class ListStackInstancesIterable
implements SdkIterable<ListStackInstancesResponse> {
    private final CloudFormationClient client;
    private final ListStackInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStackInstancesIterable(CloudFormationClient client, ListStackInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStackInstancesResponseFetcher();
    }

    public Iterator<ListStackInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StackInstanceSummary> summaries() {
        Function<ListStackInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStackInstancesResponseFetcher
    implements SyncPageFetcher<ListStackInstancesResponse> {
        private ListStackInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStackInstancesResponse nextPage(ListStackInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListStackInstancesIterable.this.client.listStackInstances(ListStackInstancesIterable.this.firstRequest);
            }
            return ListStackInstancesIterable.this.client.listStackInstances((ListStackInstancesRequest)((Object)ListStackInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

