/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeTypeConfigurationsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, BatchDescribeTypeConfigurationsRequest> {
    private static final SdkField<List<TypeConfigurationIdentifier>> TYPE_CONFIGURATION_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TypeConfigurationIdentifiers").getter(BatchDescribeTypeConfigurationsRequest.getter(BatchDescribeTypeConfigurationsRequest::typeConfigurationIdentifiers)).setter(BatchDescribeTypeConfigurationsRequest.setter(Builder::typeConfigurationIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypeConfigurationIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_CONFIGURATION_IDENTIFIERS_FIELD));
    private final List<TypeConfigurationIdentifier> typeConfigurationIdentifiers;

    private BatchDescribeTypeConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.typeConfigurationIdentifiers = builder.typeConfigurationIdentifiers;
    }

    public final boolean hasTypeConfigurationIdentifiers() {
        return this.typeConfigurationIdentifiers != null && !(this.typeConfigurationIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<TypeConfigurationIdentifier> typeConfigurationIdentifiers() {
        return this.typeConfigurationIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeConfigurationIdentifiers() ? this.typeConfigurationIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeTypeConfigurationsRequest)) {
            return false;
        }
        BatchDescribeTypeConfigurationsRequest other = (BatchDescribeTypeConfigurationsRequest)((Object)obj);
        return this.hasTypeConfigurationIdentifiers() == other.hasTypeConfigurationIdentifiers() && Objects.equals(this.typeConfigurationIdentifiers(), other.typeConfigurationIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeTypeConfigurationsRequest").add("TypeConfigurationIdentifiers", this.hasTypeConfigurationIdentifiers() ? this.typeConfigurationIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeConfigurationIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurationIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeTypeConfigurationsRequest, T> g) {
        return obj -> g.apply((BatchDescribeTypeConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private List<TypeConfigurationIdentifier> typeConfigurationIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeTypeConfigurationsRequest model) {
            super(model);
            this.typeConfigurationIdentifiers(model.typeConfigurationIdentifiers);
        }

        public final List<TypeConfigurationIdentifier.Builder> getTypeConfigurationIdentifiers() {
            List<TypeConfigurationIdentifier.Builder> result = TypeConfigurationIdentifiersCopier.copyToBuilder(this.typeConfigurationIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder typeConfigurationIdentifiers(Collection<TypeConfigurationIdentifier> typeConfigurationIdentifiers) {
            this.typeConfigurationIdentifiers = TypeConfigurationIdentifiersCopier.copy(typeConfigurationIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeConfigurationIdentifiers(TypeConfigurationIdentifier ... typeConfigurationIdentifiers) {
            this.typeConfigurationIdentifiers(Arrays.asList(typeConfigurationIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeConfigurationIdentifiers(Consumer<TypeConfigurationIdentifier.Builder> ... typeConfigurationIdentifiers) {
            this.typeConfigurationIdentifiers(Stream.of(typeConfigurationIdentifiers).map(c -> (TypeConfigurationIdentifier)((TypeConfigurationIdentifier.Builder)TypeConfigurationIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypeConfigurationIdentifiers(Collection<TypeConfigurationIdentifier.BuilderImpl> typeConfigurationIdentifiers) {
            this.typeConfigurationIdentifiers = TypeConfigurationIdentifiersCopier.copyFromBuilder(typeConfigurationIdentifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDescribeTypeConfigurationsRequest build() {
            return new BatchDescribeTypeConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeTypeConfigurationsRequest> {
        public Builder typeConfigurationIdentifiers(Collection<TypeConfigurationIdentifier> var1);

        public Builder typeConfigurationIdentifiers(TypeConfigurationIdentifier ... var1);

        public Builder typeConfigurationIdentifiers(Consumer<TypeConfigurationIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

