/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ThirdPartyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypeConfigurationIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypeConfigurationIdentifier> {
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(TypeConfigurationIdentifier.getter(TypeConfigurationIdentifier::typeArn)).setter(TypeConfigurationIdentifier.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> TYPE_CONFIGURATION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeConfigurationAlias").getter(TypeConfigurationIdentifier.getter(TypeConfigurationIdentifier::typeConfigurationAlias)).setter(TypeConfigurationIdentifier.setter(Builder::typeConfigurationAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationAlias").build()}).build();
    private static final SdkField<String> TYPE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeConfigurationArn").getter(TypeConfigurationIdentifier.getter(TypeConfigurationIdentifier::typeConfigurationArn)).setter(TypeConfigurationIdentifier.setter(Builder::typeConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TypeConfigurationIdentifier.getter(TypeConfigurationIdentifier::typeAsString)).setter(TypeConfigurationIdentifier.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(TypeConfigurationIdentifier.getter(TypeConfigurationIdentifier::typeName)).setter(TypeConfigurationIdentifier.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_ARN_FIELD, TYPE_CONFIGURATION_ALIAS_FIELD, TYPE_CONFIGURATION_ARN_FIELD, TYPE_FIELD, TYPE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String typeArn;
    private final String typeConfigurationAlias;
    private final String typeConfigurationArn;
    private final String type;
    private final String typeName;

    private TypeConfigurationIdentifier(BuilderImpl builder) {
        this.typeArn = builder.typeArn;
        this.typeConfigurationAlias = builder.typeConfigurationAlias;
        this.typeConfigurationArn = builder.typeConfigurationArn;
        this.type = builder.type;
        this.typeName = builder.typeName;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final String typeConfigurationAlias() {
        return this.typeConfigurationAlias;
    }

    public final String typeConfigurationArn() {
        return this.typeConfigurationArn;
    }

    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeConfigurationAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeConfigurationIdentifier)) {
            return false;
        }
        TypeConfigurationIdentifier other = (TypeConfigurationIdentifier)obj;
        return Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.typeConfigurationAlias(), other.typeConfigurationAlias()) && Objects.equals(this.typeConfigurationArn(), other.typeConfigurationArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName());
    }

    public final String toString() {
        return ToString.builder((String)"TypeConfigurationIdentifier").add("TypeArn", (Object)this.typeArn()).add("TypeConfigurationAlias", (Object)this.typeConfigurationAlias()).add("TypeConfigurationArn", (Object)this.typeConfigurationArn()).add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "TypeConfigurationAlias": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurationAlias()));
            }
            case "TypeConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurationArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeConfigurationIdentifier, T> g) {
        return obj -> g.apply((TypeConfigurationIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeArn;
        private String typeConfigurationAlias;
        private String typeConfigurationArn;
        private String type;
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeConfigurationIdentifier model) {
            this.typeArn(model.typeArn);
            this.typeConfigurationAlias(model.typeConfigurationAlias);
            this.typeConfigurationArn(model.typeConfigurationArn);
            this.type(model.type);
            this.typeName(model.typeName);
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        public final String getTypeConfigurationAlias() {
            return this.typeConfigurationAlias;
        }

        @Override
        public final Builder typeConfigurationAlias(String typeConfigurationAlias) {
            this.typeConfigurationAlias = typeConfigurationAlias;
            return this;
        }

        public final void setTypeConfigurationAlias(String typeConfigurationAlias) {
            this.typeConfigurationAlias = typeConfigurationAlias;
        }

        public final String getTypeConfigurationArn() {
            return this.typeConfigurationArn;
        }

        @Override
        public final Builder typeConfigurationArn(String typeConfigurationArn) {
            this.typeConfigurationArn = typeConfigurationArn;
            return this;
        }

        public final void setTypeConfigurationArn(String typeConfigurationArn) {
            this.typeConfigurationArn = typeConfigurationArn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public TypeConfigurationIdentifier build() {
            return new TypeConfigurationIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypeConfigurationIdentifier> {
        public Builder typeArn(String var1);

        public Builder typeConfigurationAlias(String var1);

        public Builder typeConfigurationArn(String var1);

        public Builder type(String var1);

        public Builder type(ThirdPartyType var1);

        public Builder typeName(String var1);
    }
}

