/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackSetResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackSetResponse> {
    private static final SdkField<StackSet> STACK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackSet").getter(DescribeStackSetResponse.getter(DescribeStackSetResponse::stackSet)).setter(DescribeStackSetResponse.setter(Builder::stackSet)).constructor(StackSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_FIELD));
    private final StackSet stackSet;

    private DescribeStackSetResponse(BuilderImpl builder) {
        super(builder);
        this.stackSet = builder.stackSet;
    }

    public StackSet stackSet() {
        return this.stackSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackSetResponse)) {
            return false;
        }
        DescribeStackSetResponse other = (DescribeStackSetResponse)((Object)obj);
        return Objects.equals(this.stackSet(), other.stackSet());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStackSetResponse").add("StackSet", (Object)this.stackSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSet": {
                return Optional.ofNullable(clazz.cast(this.stackSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackSetResponse, T> g) {
        return obj -> g.apply((DescribeStackSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private StackSet stackSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackSetResponse model) {
            super(model);
            this.stackSet(model.stackSet);
        }

        public final StackSet.Builder getStackSet() {
            return this.stackSet != null ? this.stackSet.toBuilder() : null;
        }

        @Override
        public final Builder stackSet(StackSet stackSet) {
            this.stackSet = stackSet;
            return this;
        }

        public final void setStackSet(StackSet.BuilderImpl stackSet) {
            this.stackSet = stackSet != null ? stackSet.build() : null;
        }

        @Override
        public DescribeStackSetResponse build() {
            return new DescribeStackSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackSetResponse> {
        public Builder stackSet(StackSet var1);

        default public Builder stackSet(Consumer<StackSet.Builder> stackSet) {
            return this.stackSet((StackSet)((StackSet.Builder)StackSet.builder().applyMutation(stackSet)).build());
        }
    }
}

