/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummary;

public class ListStackSetsPublisher
implements SdkPublisher<ListStackSetsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackSetsPublisher(CloudFormationAsyncClient client, ListStackSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackSetsPublisher(CloudFormationAsyncClient client, ListStackSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackSetSummary> summaries() {
        Function<ListStackSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStackSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStackSetsResponseFetcher
    implements AsyncPageFetcher<ListStackSetsResponse> {
        private ListStackSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackSetsResponse> nextPage(ListStackSetsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetsPublisher.this.client.listStackSets(ListStackSetsPublisher.this.firstRequest);
            }
            return ListStackSetsPublisher.this.client.listStackSets((ListStackSetsRequest)((Object)ListStackSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

