/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.TypeSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.TypeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypesResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListTypesResponse> {
    private static final SdkField<List<TypeSummary>> TYPE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTypesResponse.getter(ListTypesResponse::typeSummaries)).setter(ListTypesResponse.setter(Builder::typeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTypesResponse.getter(ListTypesResponse::nextToken)).setter(ListTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TypeSummary> typeSummaries;
    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        super(builder);
        this.typeSummaries = builder.typeSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTypeSummaries() {
        return this.typeSummaries != null && !(this.typeSummaries instanceof SdkAutoConstructList);
    }

    public List<TypeSummary> typeSummaries() {
        return this.typeSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse)((Object)obj);
        return Objects.equals(this.typeSummaries(), other.typeSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTypesResponse").add("TypeSummaries", this.typeSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeSummaries": {
                return Optional.ofNullable(clazz.cast(this.typeSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesResponse, T> g) {
        return obj -> g.apply((ListTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<TypeSummary> typeSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            super(model);
            this.typeSummaries(model.typeSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypeSummary.Builder> getTypeSummaries() {
            return this.typeSummaries != null ? (Collection)this.typeSummaries.stream().map(TypeSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeSummaries(Collection<TypeSummary> typeSummaries) {
            this.typeSummaries = TypeSummariesCopier.copy(typeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeSummaries(TypeSummary ... typeSummaries) {
            this.typeSummaries(Arrays.asList(typeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeSummaries(Consumer<TypeSummary.Builder> ... typeSummaries) {
            this.typeSummaries(Stream.of(typeSummaries).map(c -> (TypeSummary)((TypeSummary.Builder)TypeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypeSummaries(Collection<TypeSummary.BuilderImpl> typeSummaries) {
            this.typeSummaries = TypeSummariesCopier.copyFromBuilder(typeSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypesResponse> {
        public Builder typeSummaries(Collection<TypeSummary> var1);

        public Builder typeSummaries(TypeSummary ... var1);

        public Builder typeSummaries(Consumer<TypeSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

