/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus;
import software.amazon.awssdk.services.cloudformation.model.LoggingConfig;
import software.amazon.awssdk.services.cloudformation.model.ProvisioningType;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.services.cloudformation.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTypeResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeTypeResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::arn)).setter(DescribeTypeResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeAsString)).setter(DescribeTypeResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::typeName)).setter(DescribeTypeResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> DEFAULT_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::defaultVersionId)).setter(DescribeTypeResponse.setter(Builder::defaultVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionId").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeTypeResponse.getter(DescribeTypeResponse::isDefaultVersion)).setter(DescribeTypeResponse.setter(Builder::isDefaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::description)).setter(DescribeTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::schema)).setter(DescribeTypeResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::provisioningTypeAsString)).setter(DescribeTypeResponse.setter(Builder::provisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()}).build();
    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::deprecatedStatusAsString)).setter(DescribeTypeResponse.setter(Builder::deprecatedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeTypeResponse.getter(DescribeTypeResponse::loggingConfig)).setter(DescribeTypeResponse.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::executionRoleArn)).setter(DescribeTypeResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::visibilityAsString)).setter(DescribeTypeResponse.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::sourceUrl)).setter(DescribeTypeResponse.setter(Builder::sourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()}).build();
    private static final SdkField<String> DOCUMENTATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTypeResponse.getter(DescribeTypeResponse::documentationUrl)).setter(DescribeTypeResponse.setter(Builder::documentationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationUrl").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTypeResponse.getter(DescribeTypeResponse::lastUpdated)).setter(DescribeTypeResponse.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Instant> TIME_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeTypeResponse.getter(DescribeTypeResponse::timeCreated)).setter(DescribeTypeResponse.setter(Builder::timeCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeCreated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, TYPE_NAME_FIELD, DEFAULT_VERSION_ID_FIELD, IS_DEFAULT_VERSION_FIELD, DESCRIPTION_FIELD, SCHEMA_FIELD, PROVISIONING_TYPE_FIELD, DEPRECATED_STATUS_FIELD, LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, VISIBILITY_FIELD, SOURCE_URL_FIELD, DOCUMENTATION_URL_FIELD, LAST_UPDATED_FIELD, TIME_CREATED_FIELD));
    private final String arn;
    private final String type;
    private final String typeName;
    private final String defaultVersionId;
    private final Boolean isDefaultVersion;
    private final String description;
    private final String schema;
    private final String provisioningType;
    private final String deprecatedStatus;
    private final LoggingConfig loggingConfig;
    private final String executionRoleArn;
    private final String visibility;
    private final String sourceUrl;
    private final String documentationUrl;
    private final Instant lastUpdated;
    private final Instant timeCreated;

    private DescribeTypeResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.defaultVersionId = builder.defaultVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.description = builder.description;
        this.schema = builder.schema;
        this.provisioningType = builder.provisioningType;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.visibility = builder.visibility;
        this.sourceUrl = builder.sourceUrl;
        this.documentationUrl = builder.documentationUrl;
        this.lastUpdated = builder.lastUpdated;
        this.timeCreated = builder.timeCreated;
    }

    public String arn() {
        return this.arn;
    }

    public RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String typeName() {
        return this.typeName;
    }

    public String defaultVersionId() {
        return this.defaultVersionId;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public String description() {
        return this.description;
    }

    public String schema() {
        return this.schema;
    }

    public ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(this.provisioningType);
    }

    public String provisioningTypeAsString() {
        return this.provisioningType;
    }

    public DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(this.deprecatedStatus);
    }

    public String deprecatedStatusAsString() {
        return this.deprecatedStatus;
    }

    public LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public String visibilityAsString() {
        return this.visibility;
    }

    public String sourceUrl() {
        return this.sourceUrl;
    }

    public String documentationUrl() {
        return this.documentationUrl;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Instant timeCreated() {
        return this.timeCreated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeCreated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTypeResponse)) {
            return false;
        }
        DescribeTypeResponse other = (DescribeTypeResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.defaultVersionId(), other.defaultVersionId()) && Objects.equals(this.isDefaultVersion(), other.isDefaultVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.provisioningTypeAsString(), other.provisioningTypeAsString()) && Objects.equals(this.deprecatedStatusAsString(), other.deprecatedStatusAsString()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.sourceUrl(), other.sourceUrl()) && Objects.equals(this.documentationUrl(), other.documentationUrl()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.timeCreated(), other.timeCreated());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTypeResponse").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("DefaultVersionId", (Object)this.defaultVersionId()).add("IsDefaultVersion", (Object)this.isDefaultVersion()).add("Description", (Object)this.description()).add("Schema", (Object)this.schema()).add("ProvisioningType", (Object)this.provisioningTypeAsString()).add("DeprecatedStatus", (Object)this.deprecatedStatusAsString()).add("LoggingConfig", (Object)this.loggingConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("Visibility", (Object)this.visibilityAsString()).add("SourceUrl", (Object)this.sourceUrl()).add("DocumentationUrl", (Object)this.documentationUrl()).add("LastUpdated", (Object)this.lastUpdated()).add("TimeCreated", (Object)this.timeCreated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "DefaultVersionId": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionId()));
            }
            case "IsDefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.isDefaultVersion()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "ProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.provisioningTypeAsString()));
            }
            case "DeprecatedStatus": {
                return Optional.ofNullable(clazz.cast(this.deprecatedStatusAsString()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "SourceUrl": {
                return Optional.ofNullable(clazz.cast(this.sourceUrl()));
            }
            case "DocumentationUrl": {
                return Optional.ofNullable(clazz.cast(this.documentationUrl()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "TimeCreated": {
                return Optional.ofNullable(clazz.cast(this.timeCreated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTypeResponse, T> g) {
        return obj -> g.apply((DescribeTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String typeName;
        private String defaultVersionId;
        private Boolean isDefaultVersion;
        private String description;
        private String schema;
        private String provisioningType;
        private String deprecatedStatus;
        private LoggingConfig loggingConfig;
        private String executionRoleArn;
        private String visibility;
        private String sourceUrl;
        private String documentationUrl;
        private Instant lastUpdated;
        private Instant timeCreated;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTypeResponse model) {
            super(model);
            this.arn(model.arn);
            this.type(model.type);
            this.typeName(model.typeName);
            this.defaultVersionId(model.defaultVersionId);
            this.isDefaultVersion(model.isDefaultVersion);
            this.description(model.description);
            this.schema(model.schema);
            this.provisioningType(model.provisioningType);
            this.deprecatedStatus(model.deprecatedStatus);
            this.loggingConfig(model.loggingConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.visibility(model.visibility);
            this.sourceUrl(model.sourceUrl);
            this.documentationUrl(model.documentationUrl);
            this.lastUpdated(model.lastUpdated);
            this.timeCreated(model.timeCreated);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getDefaultVersionId() {
            return this.defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getProvisioningType() {
            return this.provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        public final String getDeprecatedStatus() {
            return this.deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final String getSourceUrl() {
            return this.sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        public final String getDocumentationUrl() {
            return this.documentationUrl;
        }

        @Override
        public final Builder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        public final void setDocumentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Instant getTimeCreated() {
            return this.timeCreated;
        }

        @Override
        public final Builder timeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
            return this;
        }

        public final void setTimeCreated(Instant timeCreated) {
            this.timeCreated = timeCreated;
        }

        @Override
        public DescribeTypeResponse build() {
            return new DescribeTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTypeResponse> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder defaultVersionId(String var1);

        public Builder isDefaultVersion(Boolean var1);

        public Builder description(String var1);

        public Builder schema(String var1);

        public Builder provisioningType(String var1);

        public Builder provisioningType(ProvisioningType var1);

        public Builder deprecatedStatus(String var1);

        public Builder deprecatedStatus(DeprecatedStatus var1);

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder sourceUrl(String var1);

        public Builder documentationUrl(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder timeCreated(Instant var1);
    }
}

