/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTerminationProtectionRequest extends CloudFormationRequest implements
        ToCopyableBuilder<UpdateTerminationProtectionRequest.Builder, UpdateTerminationProtectionRequest> {
    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateTerminationProtectionRequest::enableTerminationProtection))
            .setter(setter(Builder::enableTerminationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection")
                    .build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTerminationProtectionRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_TERMINATION_PROTECTION_FIELD, STACK_NAME_FIELD));

    private final Boolean enableTerminationProtection;

    private final String stackName;

    private UpdateTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * Whether to enable termination protection on the specified stack.
     * </p>
     * 
     * @return Whether to enable termination protection on the specified stack.
     */
    public Boolean enableTerminationProtection() {
        return enableTerminationProtection;
    }

    /**
     * <p>
     * The name or unique ID of the stack for which you want to set termination protection.
     * </p>
     * 
     * @return The name or unique ID of the stack for which you want to set termination protection.
     */
    public String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTerminationProtectionRequest)) {
            return false;
        }
        UpdateTerminationProtectionRequest other = (UpdateTerminationProtectionRequest) obj;
        return Objects.equals(enableTerminationProtection(), other.enableTerminationProtection())
                && Objects.equals(stackName(), other.stackName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTerminationProtectionRequest")
                .add("EnableTerminationProtection", enableTerminationProtection()).add("StackName", stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableTerminationProtection":
            return Optional.ofNullable(clazz.cast(enableTerminationProtection()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTerminationProtectionRequest, T> g) {
        return obj -> g.apply((UpdateTerminationProtectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
        /**
         * <p>
         * Whether to enable termination protection on the specified stack.
         * </p>
         * 
         * @param enableTerminationProtection
         *        Whether to enable termination protection on the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTerminationProtection(Boolean enableTerminationProtection);

        /**
         * <p>
         * The name or unique ID of the stack for which you want to set termination protection.
         * </p>
         * 
         * @param stackName
         *        The name or unique ID of the stack for which you want to set termination protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private Boolean enableTerminationProtection;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTerminationProtectionRequest model) {
            super(model);
            enableTerminationProtection(model.enableTerminationProtection);
            stackName(model.stackName);
        }

        public final Boolean getEnableTerminationProtection() {
            return enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTerminationProtectionRequest build() {
            return new UpdateTerminationProtectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
