/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The user-specified preferences for how AWS CloudFormation performs a stack set operation.
 * </p>
 * <p>
 * For more information on maximum concurrent accounts and failure tolerance, see <a
 * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options"
 * >Stack set operation options</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StackSetOperationPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<StackSetOperationPreferences.Builder, StackSetOperationPreferences> {
    private static final SdkField<List<String>> REGION_ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StackSetOperationPreferences::regionOrder))
            .setter(setter(Builder::regionOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionOrder").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> FAILURE_TOLERANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSetOperationPreferences::failureToleranceCount)).setter(setter(Builder::failureToleranceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureToleranceCount").build())
            .build();

    private static final SdkField<Integer> FAILURE_TOLERANCE_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSetOperationPreferences::failureTolerancePercentage))
            .setter(setter(Builder::failureTolerancePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureTolerancePercentage").build())
            .build();

    private static final SdkField<Integer> MAX_CONCURRENT_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSetOperationPreferences::maxConcurrentCount)).setter(setter(Builder::maxConcurrentCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentCount").build())
            .build();

    private static final SdkField<Integer> MAX_CONCURRENT_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StackSetOperationPreferences::maxConcurrentPercentage))
            .setter(setter(Builder::maxConcurrentPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_ORDER_FIELD,
            FAILURE_TOLERANCE_COUNT_FIELD, FAILURE_TOLERANCE_PERCENTAGE_FIELD, MAX_CONCURRENT_COUNT_FIELD,
            MAX_CONCURRENT_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> regionOrder;

    private final Integer failureToleranceCount;

    private final Integer failureTolerancePercentage;

    private final Integer maxConcurrentCount;

    private final Integer maxConcurrentPercentage;

    private StackSetOperationPreferences(BuilderImpl builder) {
        this.regionOrder = builder.regionOrder;
        this.failureToleranceCount = builder.failureToleranceCount;
        this.failureTolerancePercentage = builder.failureTolerancePercentage;
        this.maxConcurrentCount = builder.maxConcurrentCount;
        this.maxConcurrentPercentage = builder.maxConcurrentPercentage;
    }

    /**
     * Returns true if the RegionOrder property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRegionOrder() {
        return regionOrder != null && !(regionOrder instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order of the Regions in where you want to perform the stack operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegionOrder()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The order of the Regions in where you want to perform the stack operation.
     */
    public List<String> regionOrder() {
        return regionOrder;
    }

    /**
     * <p>
     * The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the
     * operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the
     * operation in any subsequent Regions.
     * </p>
     * <p>
     * Conditional: You must specify either <code>FailureToleranceCount</code> or
     * <code>FailureTolerancePercentage</code> (but not both).
     * </p>
     * 
     * @return The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the
     *         operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the
     *         operation in any subsequent Regions.</p>
     *         <p>
     *         Conditional: You must specify either <code>FailureToleranceCount</code> or
     *         <code>FailureTolerancePercentage</code> (but not both).
     */
    public Integer failureToleranceCount() {
        return failureToleranceCount;
    }

    /**
     * <p>
     * The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops
     * the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the
     * operation in any subsequent Regions.
     * </p>
     * <p>
     * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds <i>down</i>
     * to the next whole number.
     * </p>
     * <p>
     * Conditional: You must specify either <code>FailureToleranceCount</code> or
     * <code>FailureTolerancePercentage</code>, but not both.
     * </p>
     * 
     * @return The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation
     *         stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't
     *         attempt the operation in any subsequent Regions.</p>
     *         <p>
     *         When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds
     *         <i>down</i> to the next whole number.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>FailureToleranceCount</code> or
     *         <code>FailureTolerancePercentage</code>, but not both.
     */
    public Integer failureTolerancePercentage() {
        return failureTolerancePercentage;
    }

    /**
     * <p>
     * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of
     * <code>FailureToleranceCount</code>—<code>MaxConcurrentCount</code> is at most one more than the
     * <code>FailureToleranceCount</code> .
     * </p>
     * <p>
     * Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain
     * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     * </p>
     * <p>
     * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but
     * not both.
     * </p>
     * 
     * @return The maximum number of accounts in which to perform this operation at one time. This is dependent on the
     *         value of <code>FailureToleranceCount</code>—<code>MaxConcurrentCount</code> is at most one more than the
     *         <code>FailureToleranceCount</code> .</p>
     *         <p>
     *         Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under
     *         certain circumstances the actual number of accounts acted upon concurrently may be lower due to service
     *         throttling.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>MaxConcurrentCount</code> or
     *         <code>MaxConcurrentPercentage</code>, but not both.
     */
    public Integer maxConcurrentCount() {
        return maxConcurrentCount;
    }

    /**
     * <p>
     * The maximum percentage of accounts in which to perform this operation at one time.
     * </p>
     * <p>
     * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to the
     * next whole number. This is true except in cases where rounding down would result is zero. In this case,
     * CloudFormation sets the number as one instead.
     * </p>
     * <p>
     * Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under certain
     * circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     * </p>
     * <p>
     * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>, but
     * not both.
     * </p>
     * 
     * @return The maximum percentage of accounts in which to perform this operation at one time.</p>
     *         <p>
     *         When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down
     *         to the next whole number. This is true except in cases where rounding down would result is zero. In this
     *         case, CloudFormation sets the number as one instead.
     *         </p>
     *         <p>
     *         Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under
     *         certain circumstances the actual number of accounts acted upon concurrently may be lower due to service
     *         throttling.
     *         </p>
     *         <p>
     *         Conditional: You must specify either <code>MaxConcurrentCount</code> or
     *         <code>MaxConcurrentPercentage</code>, but not both.
     */
    public Integer maxConcurrentPercentage() {
        return maxConcurrentPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionOrder());
        hashCode = 31 * hashCode + Objects.hashCode(failureToleranceCount());
        hashCode = 31 * hashCode + Objects.hashCode(failureTolerancePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationPreferences)) {
            return false;
        }
        StackSetOperationPreferences other = (StackSetOperationPreferences) obj;
        return Objects.equals(regionOrder(), other.regionOrder())
                && Objects.equals(failureToleranceCount(), other.failureToleranceCount())
                && Objects.equals(failureTolerancePercentage(), other.failureTolerancePercentage())
                && Objects.equals(maxConcurrentCount(), other.maxConcurrentCount())
                && Objects.equals(maxConcurrentPercentage(), other.maxConcurrentPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StackSetOperationPreferences").add("RegionOrder", regionOrder())
                .add("FailureToleranceCount", failureToleranceCount())
                .add("FailureTolerancePercentage", failureTolerancePercentage()).add("MaxConcurrentCount", maxConcurrentCount())
                .add("MaxConcurrentPercentage", maxConcurrentPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionOrder":
            return Optional.ofNullable(clazz.cast(regionOrder()));
        case "FailureToleranceCount":
            return Optional.ofNullable(clazz.cast(failureToleranceCount()));
        case "FailureTolerancePercentage":
            return Optional.ofNullable(clazz.cast(failureTolerancePercentage()));
        case "MaxConcurrentCount":
            return Optional.ofNullable(clazz.cast(maxConcurrentCount()));
        case "MaxConcurrentPercentage":
            return Optional.ofNullable(clazz.cast(maxConcurrentPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackSetOperationPreferences, T> g) {
        return obj -> g.apply((StackSetOperationPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StackSetOperationPreferences> {
        /**
         * <p>
         * The order of the Regions in where you want to perform the stack operation.
         * </p>
         * 
         * @param regionOrder
         *        The order of the Regions in where you want to perform the stack operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOrder(Collection<String> regionOrder);

        /**
         * <p>
         * The order of the Regions in where you want to perform the stack operation.
         * </p>
         * 
         * @param regionOrder
         *        The order of the Regions in where you want to perform the stack operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionOrder(String... regionOrder);

        /**
         * <p>
         * The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the
         * operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't attempt the
         * operation in any subsequent Regions.
         * </p>
         * <p>
         * Conditional: You must specify either <code>FailureToleranceCount</code> or
         * <code>FailureTolerancePercentage</code> (but not both).
         * </p>
         * 
         * @param failureToleranceCount
         *        The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops
         *        the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't
         *        attempt the operation in any subsequent Regions.</p>
         *        <p>
         *        Conditional: You must specify either <code>FailureToleranceCount</code> or
         *        <code>FailureTolerancePercentage</code> (but not both).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureToleranceCount(Integer failureToleranceCount);

        /**
         * <p>
         * The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation
         * stops the operation in that Region. If the operation is stopped in a Region, AWS CloudFormation doesn't
         * attempt the operation in any subsequent Regions.
         * </p>
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds
         * <i>down</i> to the next whole number.
         * </p>
         * <p>
         * Conditional: You must specify either <code>FailureToleranceCount</code> or
         * <code>FailureTolerancePercentage</code>, but not both.
         * </p>
         * 
         * @param failureTolerancePercentage
         *        The percentage of accounts, per Region, for which this stack operation can fail before AWS
         *        CloudFormation stops the operation in that Region. If the operation is stopped in a Region, AWS
         *        CloudFormation doesn't attempt the operation in any subsequent Regions.</p>
         *        <p>
         *        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds
         *        <i>down</i> to the next whole number.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>FailureToleranceCount</code> or
         *        <code>FailureTolerancePercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureTolerancePercentage(Integer failureTolerancePercentage);

        /**
         * <p>
         * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value
         * of <code>FailureToleranceCount</code>—<code>MaxConcurrentCount</code> is at most one more than the
         * <code>FailureToleranceCount</code> .
         * </p>
         * <p>
         * Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under
         * certain circumstances the actual number of accounts acted upon concurrently may be lower due to service
         * throttling.
         * </p>
         * <p>
         * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>,
         * but not both.
         * </p>
         * 
         * @param maxConcurrentCount
         *        The maximum number of accounts in which to perform this operation at one time. This is dependent on
         *        the value of <code>FailureToleranceCount</code>—<code>MaxConcurrentCount</code> is at most one more
         *        than the <code>FailureToleranceCount</code> .</p>
         *        <p>
         *        Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments,
         *        under certain circumstances the actual number of accounts acted upon concurrently may be lower due to
         *        service throttling.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>MaxConcurrentCount</code> or
         *        <code>MaxConcurrentPercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentCount(Integer maxConcurrentCount);

        /**
         * <p>
         * The maximum percentage of accounts in which to perform this operation at one time.
         * </p>
         * <p>
         * When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds down to
         * the next whole number. This is true except in cases where rounding down would result is zero. In this case,
         * CloudFormation sets the number as one instead.
         * </p>
         * <p>
         * Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments, under
         * certain circumstances the actual number of accounts acted upon concurrently may be lower due to service
         * throttling.
         * </p>
         * <p>
         * Conditional: You must specify either <code>MaxConcurrentCount</code> or <code>MaxConcurrentPercentage</code>,
         * but not both.
         * </p>
         * 
         * @param maxConcurrentPercentage
         *        The maximum percentage of accounts in which to perform this operation at one time.</p>
         *        <p>
         *        When calculating the number of accounts based on the specified percentage, AWS CloudFormation rounds
         *        down to the next whole number. This is true except in cases where rounding down would result is zero.
         *        In this case, CloudFormation sets the number as one instead.
         *        </p>
         *        <p>
         *        Note that this setting lets you specify the <i>maximum</i> for operations. For large deployments,
         *        under certain circumstances the actual number of accounts acted upon concurrently may be lower due to
         *        service throttling.
         *        </p>
         *        <p>
         *        Conditional: You must specify either <code>MaxConcurrentCount</code> or
         *        <code>MaxConcurrentPercentage</code>, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentPercentage(Integer maxConcurrentPercentage);
    }

    static final class BuilderImpl implements Builder {
        private List<String> regionOrder = DefaultSdkAutoConstructList.getInstance();

        private Integer failureToleranceCount;

        private Integer failureTolerancePercentage;

        private Integer maxConcurrentCount;

        private Integer maxConcurrentPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationPreferences model) {
            regionOrder(model.regionOrder);
            failureToleranceCount(model.failureToleranceCount);
            failureTolerancePercentage(model.failureTolerancePercentage);
            maxConcurrentCount(model.maxConcurrentCount);
            maxConcurrentPercentage(model.maxConcurrentPercentage);
        }

        public final Collection<String> getRegionOrder() {
            return regionOrder;
        }

        @Override
        public final Builder regionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOrder(String... regionOrder) {
            regionOrder(Arrays.asList(regionOrder));
            return this;
        }

        public final void setRegionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
        }

        public final Integer getFailureToleranceCount() {
            return failureToleranceCount;
        }

        @Override
        public final Builder failureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
            return this;
        }

        public final void setFailureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
        }

        public final Integer getFailureTolerancePercentage() {
            return failureTolerancePercentage;
        }

        @Override
        public final Builder failureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        public final void setFailureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
        }

        public final Integer getMaxConcurrentCount() {
            return maxConcurrentCount;
        }

        @Override
        public final Builder maxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
            return this;
        }

        public final void setMaxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
        }

        public final Integer getMaxConcurrentPercentage() {
            return maxConcurrentPercentage;
        }

        @Override
        public final Builder maxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
            return this;
        }

        public final void setMaxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
        }

        @Override
        public StackSetOperationPreferences build() {
            return new StackSetOperationPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
