/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a resource property whose actual value differs from its expected value, as defined in the stack
 * template and any values specified as template parameters. These will be present only for resources whose
 * <code>StackResourceDriftStatus</code> is <code>MODIFIED</code>. For more information, see <a
 * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html">Detecting
 * Unregulated Configuration Changes to Stacks and Resources</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyDifference implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyDifference.Builder, PropertyDifference> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PropertyDifference::propertyPath)).setter(setter(Builder::propertyPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()).build();

    private static final SdkField<String> EXPECTED_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PropertyDifference::expectedValue)).setter(setter(Builder::expectedValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedValue").build()).build();

    private static final SdkField<String> ACTUAL_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PropertyDifference::actualValue)).setter(setter(Builder::actualValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()).build();

    private static final SdkField<String> DIFFERENCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PropertyDifference::differenceTypeAsString)).setter(setter(Builder::differenceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD,
            EXPECTED_VALUE_FIELD, ACTUAL_VALUE_FIELD, DIFFERENCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyPath;

    private final String expectedValue;

    private final String actualValue;

    private final String differenceType;

    private PropertyDifference(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.expectedValue = builder.expectedValue;
        this.actualValue = builder.actualValue;
        this.differenceType = builder.differenceType;
    }

    /**
     * <p>
     * The fully-qualified path to the resource property.
     * </p>
     * 
     * @return The fully-qualified path to the resource property.
     */
    public String propertyPath() {
        return propertyPath;
    }

    /**
     * <p>
     * The expected property value of the resource property, as defined in the stack template and any values specified
     * as template parameters.
     * </p>
     * 
     * @return The expected property value of the resource property, as defined in the stack template and any values
     *         specified as template parameters.
     */
    public String expectedValue() {
        return expectedValue;
    }

    /**
     * <p>
     * The actual property value of the resource property.
     * </p>
     * 
     * @return The actual property value of the resource property.
     */
    public String actualValue() {
        return actualValue;
    }

    /**
     * <p>
     * The type of property difference.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code>: The property has been removed from the current resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack
     * template and any values specified as template parameters).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceType}
     * will return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceTypeAsString}.
     * </p>
     * 
     * @return The type of property difference.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code>: The property has been removed from the current resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the
     *         stack template and any values specified as template parameters).
     *         </p>
     *         </li>
     * @see DifferenceType
     */
    public DifferenceType differenceType() {
        return DifferenceType.fromValue(differenceType);
    }

    /**
     * <p>
     * The type of property difference.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REMOVE</code>: The property has been removed from the current resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack
     * template and any values specified as template parameters).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceType}
     * will return {@link DifferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceTypeAsString}.
     * </p>
     * 
     * @return The type of property difference.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REMOVE</code>: The property has been removed from the current resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the
     *         stack template and any values specified as template parameters).
     *         </p>
     *         </li>
     * @see DifferenceType
     */
    public String differenceTypeAsString() {
        return differenceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(expectedValue());
        hashCode = 31 * hashCode + Objects.hashCode(actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(differenceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDifference)) {
            return false;
        }
        PropertyDifference other = (PropertyDifference) obj;
        return Objects.equals(propertyPath(), other.propertyPath()) && Objects.equals(expectedValue(), other.expectedValue())
                && Objects.equals(actualValue(), other.actualValue())
                && Objects.equals(differenceTypeAsString(), other.differenceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PropertyDifference").add("PropertyPath", propertyPath()).add("ExpectedValue", expectedValue())
                .add("ActualValue", actualValue()).add("DifferenceType", differenceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyPath":
            return Optional.ofNullable(clazz.cast(propertyPath()));
        case "ExpectedValue":
            return Optional.ofNullable(clazz.cast(expectedValue()));
        case "ActualValue":
            return Optional.ofNullable(clazz.cast(actualValue()));
        case "DifferenceType":
            return Optional.ofNullable(clazz.cast(differenceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyDifference, T> g) {
        return obj -> g.apply((PropertyDifference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyDifference> {
        /**
         * <p>
         * The fully-qualified path to the resource property.
         * </p>
         * 
         * @param propertyPath
         *        The fully-qualified path to the resource property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyPath(String propertyPath);

        /**
         * <p>
         * The expected property value of the resource property, as defined in the stack template and any values
         * specified as template parameters.
         * </p>
         * 
         * @param expectedValue
         *        The expected property value of the resource property, as defined in the stack template and any values
         *        specified as template parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedValue(String expectedValue);

        /**
         * <p>
         * The actual property value of the resource property.
         * </p>
         * 
         * @param actualValue
         *        The actual property value of the resource property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualValue(String actualValue);

        /**
         * <p>
         * The type of property difference.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code>: The property has been removed from the current resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack
         * template and any values specified as template parameters).
         * </p>
         * </li>
         * </ul>
         * 
         * @param differenceType
         *        The type of property difference.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code>: The property has been removed from the current resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the
         *        stack template and any values specified as template parameters).
         *        </p>
         *        </li>
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder differenceType(String differenceType);

        /**
         * <p>
         * The type of property difference.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REMOVE</code>: The property has been removed from the current resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the stack
         * template and any values specified as template parameters).
         * </p>
         * </li>
         * </ul>
         * 
         * @param differenceType
         *        The type of property difference.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ADD</code>: A value has been added to a resource property that is an array or list data type.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REMOVE</code>: The property has been removed from the current resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_EQUAL</code>: The current property value differs from its expected value (as defined in the
         *        stack template and any values specified as template parameters).
         *        </p>
         *        </li>
         * @see DifferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceType
         */
        Builder differenceType(DifferenceType differenceType);
    }

    static final class BuilderImpl implements Builder {
        private String propertyPath;

        private String expectedValue;

        private String actualValue;

        private String differenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDifference model) {
            propertyPath(model.propertyPath);
            expectedValue(model.expectedValue);
            actualValue(model.actualValue);
            differenceType(model.differenceType);
        }

        public final String getPropertyPath() {
            return propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        public final String getExpectedValue() {
            return expectedValue;
        }

        @Override
        public final Builder expectedValue(String expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public final void setExpectedValue(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        public final String getActualValue() {
            return actualValue;
        }

        @Override
        public final Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final void setActualValue(String actualValue) {
            this.actualValue = actualValue;
        }

        public final String getDifferenceType() {
            return differenceType;
        }

        @Override
        public final Builder differenceType(String differenceType) {
            this.differenceType = differenceType;
            return this;
        }

        @Override
        public final Builder differenceType(DifferenceType differenceType) {
            this.differenceType(differenceType == null ? null : differenceType.toString());
            return this;
        }

        public final void setDifferenceType(String differenceType) {
            this.differenceType = differenceType;
        }

        @Override
        public PropertyDifference build() {
            return new PropertyDifference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
